/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks.OreWasher;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ElectricDustWasher
extends AContainer {
    private final OreWasher oreWasher = SlimefunItems.ORE_WASHER.getItem(OreWasher.class);
    private final boolean legacyMode = Slimefun.getCfg().getBoolean("options.legacy-dust-washer");

    @ParametersAreNonnullByDefault
    public ElectricDustWasher(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.GOLDEN_SHOVEL);
    }

    @Override
    protected MachineRecipe findNextRecipe(BlockMenu menu) {
        for (int slot : this.getInputSlots()) {
            MachineRecipe recipe;
            if (SlimefunUtils.isItemSimilar(menu.getItemInSlot(slot), SlimefunItems.SIFTED_ORE, true, false)) {
                if (!this.legacyMode && !this.hasFreeSlot(menu)) {
                    return null;
                }
                ItemStack dust = this.oreWasher.getRandomDust();
                MachineRecipe recipe2 = new MachineRecipe(4 / this.getSpeed(), new ItemStack[]{SlimefunItems.SIFTED_ORE}, new ItemStack[]{dust});
                if (this.legacyMode && !menu.fits(recipe2.getOutput()[0], this.getOutputSlots())) continue;
                menu.consumeItem(slot);
                return recipe2;
            }
            if (!SlimefunUtils.isItemSimilar(menu.getItemInSlot(slot), SlimefunItems.PULVERIZED_ORE, true) || !menu.fits((recipe = new MachineRecipe(4 / this.getSpeed(), new ItemStack[]{SlimefunItems.PULVERIZED_ORE}, new ItemStack[]{SlimefunItems.PURE_ORE_CLUSTER})).getOutput()[0], this.getOutputSlots())) continue;
            menu.consumeItem(slot);
            return recipe;
        }
        return null;
    }

    private boolean hasFreeSlot(BlockMenu menu) {
        for (int slot : this.getOutputSlots()) {
            ItemStack item = menu.getItemInSlot(slot);
            if (item != null && item.getType() != Material.AIR) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getMachineIdentifier() {
        return "ELECTRIC_DUST_WASHER";
    }
}

