/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines.enchanting;

import io.github.thebusybiscuit.slimefun4.api.events.AsyncAutoEnchanterProcessEvent;
import io.github.thebusybiscuit.slimefun4.api.events.AutoEnchantEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines.enchanting.AbstractEnchantmentMachine;
import io.github.thebusybiscuit.slimefun4.libraries.dough.inventory.InvUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;

public class AutoEnchanter
extends AbstractEnchantmentMachine {
    private final ItemSetting<Boolean> overrideExistingEnchantsLvl = new ItemSetting<Boolean>(this, "override-existing-enchants-lvl", false);

    @ParametersAreNonnullByDefault
    public AutoEnchanter(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.addItemSetting(this.overrideExistingEnchantsLvl);
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.GOLDEN_CHESTPLATE);
    }

    @Override
    protected MachineRecipe findNextRecipe(BlockMenu menu) {
        for (int slot : this.getInputSlots()) {
            ItemStack item = menu.getItemInSlot(slot == this.getInputSlots()[0] ? this.getInputSlots()[1] : this.getInputSlots()[0]);
            if (!this.isEnchantable(item)) continue;
            AutoEnchantEvent event = new AutoEnchantEvent(item);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return null;
            }
            ItemStack enchantedBook = menu.getItemInSlot(slot);
            if (enchantedBook == null || enchantedBook.getType() != Material.ENCHANTED_BOOK) continue;
            return this.enchant(menu, item, enchantedBook);
        }
        return null;
    }

    @Nullable
    @ParametersAreNonnullByDefault
    protected MachineRecipe enchant(BlockMenu menu, ItemStack target, ItemStack enchantedBook) {
        AsyncAutoEnchanterProcessEvent event = new AsyncAutoEnchanterProcessEvent(target, enchantedBook, menu);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        EnchantmentStorageMeta meta = (EnchantmentStorageMeta)enchantedBook.getItemMeta();
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
        for (Map.Entry entry : meta.getStoredEnchants().entrySet()) {
            if (!((Enchantment)entry.getKey()).canEnchantItem(target)) continue;
            if (this.isEnchantmentLevelAllowed((Integer)entry.getValue())) {
                enchantments.put((Enchantment)entry.getKey(), (Integer)entry.getValue());
                continue;
            }
            if (menu.toInventory().getViewers().isEmpty()) continue;
            this.showEnchantmentLevelWarning(menu);
            return null;
        }
        if (!this.overrideExistingEnchantsLvl.getValue().booleanValue()) {
            enchantments.entrySet().removeIf(e -> target.getEnchantmentLevel((Enchantment)e.getKey()) >= (Integer)e.getValue());
        }
        if (this.isEnchantmentAmountAllowed(target)) {
            return null;
        }
        if (!enchantments.isEmpty()) {
            ItemStack enchantedItem = target.clone();
            enchantedItem.setAmount(1);
            enchantedItem.addUnsafeEnchantments(enchantments);
            MachineRecipe recipe = new MachineRecipe(75 * enchantments.size() / this.getSpeed(), new ItemStack[]{target, enchantedBook}, new ItemStack[]{enchantedItem, new ItemStack(Material.BOOK)});
            if (!InvUtils.fitAll(menu.toInventory(), recipe.getOutput(), this.getOutputSlots())) {
                return null;
            }
            for (int inputSlot : this.getInputSlots()) {
                menu.consumeItem(inputSlot);
            }
            return recipe;
        }
        return null;
    }

    private boolean isEnchantable(@Nullable ItemStack item) {
        if (item != null && item.getType() != Material.ENCHANTED_BOOK && !item.getType().isAir() && !this.hasIgnoredLore(item)) {
            SlimefunItem sfItem = SlimefunItem.getByItem(item);
            return sfItem == null || sfItem.isEnchantable();
        }
        return false;
    }

    @Override
    public String getMachineIdentifier() {
        return "AUTO_ENCHANTER";
    }
}

