/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.items;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.SlimefunBranch;
import io.github.thebusybiscuit.slimefun4.api.exceptions.IdConflictException;
import io.github.thebusybiscuit.slimefun4.api.exceptions.IncompatibleItemHandlerException;
import io.github.thebusybiscuit.slimefun4.api.exceptions.MissingDependencyException;
import io.github.thebusybiscuit.slimefun4.api.exceptions.UnregisteredItemException;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.ItemState;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.api.researches.Research;
import io.github.thebusybiscuit.slimefun4.core.SlimefunRegistry;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotConfigurable;
import io.github.thebusybiscuit.slimefun4.core.attributes.Placeable;
import io.github.thebusybiscuit.slimefun4.core.attributes.Radioactive;
import io.github.thebusybiscuit.slimefun4.core.attributes.Rechargeable;
import io.github.thebusybiscuit.slimefun4.core.handlers.GlobalItemHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.VanillaItem;
import io.github.thebusybiscuit.slimefun4.implementation.items.backpacks.SlimefunBackpack;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.OptionalMap;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;

public class SlimefunItem
implements Placeable {
    private final String id;
    private final ItemStack itemStackTemplate;
    protected SlimefunAddon addon;
    private ItemState state = ItemState.UNREGISTERED;
    private ItemGroup itemGroup;
    private Research research;
    private ItemStack[] recipe;
    private RecipeType recipeType;
    protected ItemStack recipeOutput;
    protected boolean enchantable = true;
    protected boolean disenchantable = true;
    protected boolean hidden = false;
    protected boolean useableInWorkbench = false;
    private Optional<String> wikiURL = Optional.empty();
    private final OptionalMap<Class<? extends ItemHandler>, ItemHandler> itemhandlers = new OptionalMap(HashMap::new);
    private final Set<ItemSetting<?>> itemSettings = new HashSet();
    private boolean ticking = false;
    private BlockTicker blockTicker;

    @ParametersAreNonnullByDefault
    public SlimefunItem(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        this(itemGroup, item, recipeType, recipe, null);
    }

    @ParametersAreNonnullByDefault
    public SlimefunItem(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, @Nullable ItemStack recipeOutput) {
        Validate.notNull(itemGroup, "'itemGroup' is not allowed to be null!");
        Validate.notNull((Object)item, "'item' is not allowed to be null!");
        Validate.notNull(recipeType, "'recipeType' is not allowed to be null!");
        this.itemGroup = itemGroup;
        this.itemStackTemplate = item;
        this.id = item.getItemId();
        this.recipeType = recipeType;
        this.recipe = recipe;
        this.recipeOutput = recipeOutput;
    }

    @ParametersAreNonnullByDefault
    protected SlimefunItem(ItemGroup itemGroup, ItemStack item, String id, RecipeType recipeType, ItemStack[] recipe) {
        Validate.notNull(itemGroup, "'itemGroup' is not allowed to be null!");
        Validate.notNull(item, "'item' is not allowed to be null!");
        Validate.notNull(id, "'id' is not allowed to be null!");
        Validate.notNull(recipeType, "'recipeType' is not allowed to be null!");
        this.itemGroup = itemGroup;
        this.itemStackTemplate = item;
        this.id = id;
        this.recipeType = recipeType;
        this.recipe = recipe;
    }

    @Nonnull
    public final String getId() {
        return this.id;
    }

    @Nonnull
    public ItemState getState() {
        return this.state;
    }

    @Nonnull
    public ItemStack getItem() {
        return this.itemStackTemplate;
    }

    @Nonnull
    public ItemGroup getItemGroup() {
        return this.itemGroup;
    }

    @Nonnull
    public ItemStack[] getRecipe() {
        return this.recipe;
    }

    @Nonnull
    public RecipeType getRecipeType() {
        return this.recipeType;
    }

    @Nonnull
    public ItemStack getRecipeOutput() {
        return this.recipeOutput != null ? this.recipeOutput.clone() : this.itemStackTemplate.clone();
    }

    @Nullable
    public final Research getResearch() {
        return this.research;
    }

    public final boolean hasResearch() {
        return this.research != null;
    }

    @Nonnull
    public Set<ItemSetting<?>> getItemSettings() {
        return this.itemSettings;
    }

    @Nonnull
    public <T> Optional<ItemSetting<T>> getItemSetting(@Nonnull String key, @Nonnull Class<T> c) {
        for (ItemSetting<T> itemSetting : this.itemSettings) {
            if (!itemSetting.getKey().equals(key) || !itemSetting.isType(c)) continue;
            return Optional.of(itemSetting);
        }
        return Optional.empty();
    }

    public boolean isEnchantable() {
        return this.enchantable;
    }

    public boolean isDisenchantable() {
        return this.disenchantable;
    }

    public final boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        if (this.hidden != hidden) {
            this.hidden = hidden;
            if (this.state == ItemState.ENABLED) {
                if (hidden) {
                    this.itemGroup.remove(this);
                } else {
                    this.itemGroup.add(this);
                }
            }
        }
    }

    public boolean isDisabled() {
        if (this.state == ItemState.UNREGISTERED) {
            this.error("isDisabled() cannot be called before registering the item", new UnregisteredItemException(this));
            return false;
        }
        return this.state != ItemState.ENABLED;
    }

    public boolean isDisabledIn(@Nonnull World world) {
        if (this.state == ItemState.UNREGISTERED) {
            this.error("isDisabled(World) cannot be called before registering the item", new UnregisteredItemException(this));
            return false;
        }
        return this.isDisabled() || !Slimefun.getWorldSettingsService().isEnabled(world, this);
    }

    @Nonnull
    public final SlimefunAddon getAddon() {
        if (this.addon == null) {
            throw new UnregisteredItemException(this);
        }
        return this.addon;
    }

    public BlockTicker getBlockTicker() {
        return this.blockTicker;
    }

    public void register(@Nonnull SlimefunAddon addon) {
        Validate.notNull(addon, "A SlimefunAddon cannot be null!");
        Validate.notNull(addon.getJavaPlugin(), "SlimefunAddon#getJavaPlugin() is not allowed to return null!");
        this.addon = addon;
        try {
            ItemStack itemStack;
            this.checkDependencies(addon);
            this.checkForConflicts();
            this.preRegister();
            if (this.recipe == null) {
                this.recipe = new ItemStack[9];
            } else if (this.recipe.length < 9) {
                this.recipe = Arrays.copyOf(this.recipe, 9);
            }
            Slimefun.getRegistry().getAllSlimefunItems().add(this);
            Slimefun.getRegistry().getSlimefunItemIds().put(this.id, this);
            if (!(this instanceof NotConfigurable)) {
                Slimefun.getItemCfg().setDefaultValue(this.id + ".enabled", true);
                Slimefun.getItemCfg().setDefaultValue(this.id + ".can-be-used-in-workbenches", this.useableInWorkbench);
                Slimefun.getItemCfg().setDefaultValue(this.id + ".hide-in-guide", this.hidden);
                Slimefun.getItemCfg().setDefaultValue(this.id + ".allow-enchanting", this.enchantable);
                Slimefun.getItemCfg().setDefaultValue(this.id + ".allow-disenchanting", this.disenchantable);
                for (ItemSetting<?> setting : this.itemSettings) {
                    setting.reload();
                }
            }
            if (this.ticking && !Slimefun.getCfg().getBoolean("URID.enable-tickers")) {
                this.state = ItemState.DISABLED;
                return;
            }
            if (this instanceof NotConfigurable) {
                this.state = ItemState.ENABLED;
            } else if (Slimefun.getItemCfg().getBoolean(this.id + ".enabled")) {
                this.state = ItemState.ENABLED;
                this.useableInWorkbench = Slimefun.getItemCfg().getBoolean(this.id + ".can-be-used-in-workbenches");
                this.hidden = Slimefun.getItemCfg().getBoolean(this.id + ".hide-in-guide");
                this.enchantable = Slimefun.getItemCfg().getBoolean(this.id + ".allow-enchanting");
                this.disenchantable = Slimefun.getItemCfg().getBoolean(this.id + ".allow-disenchanting");
            } else {
                this.state = this instanceof VanillaItem ? ItemState.VANILLA_FALLBACK : ItemState.DISABLED;
            }
            if (this.state == ItemState.ENABLED) {
                this.onEnable();
            }
            if ((itemStack = this.itemStackTemplate) instanceof SlimefunItemStack) {
                SlimefunItemStack stack = (SlimefunItemStack)itemStack;
                if (this.isItemStackImmutable()) {
                    stack.lock();
                }
            }
            this.postRegister();
            if (Slimefun.getRegistry().isAutoLoadingEnabled() && this.state == ItemState.ENABLED) {
                this.info("Item was registered during runtime.");
                this.load();
            }
        }
        catch (Exception x) {
            this.error("Registering " + this.toString() + " has failed!", x);
        }
    }

    private final void onEnable() {
        if (!this.itemGroup.isRegistered()) {
            this.itemGroup.register(this.addon);
        }
        this.checkForDeprecations(this.getClass());
        if (this.itemStackTemplate.getAmount() != 1) {
            this.warn("This item has an illegal stack size: " + this.itemStackTemplate.getAmount() + ". An Item size of 1 is recommended. Please inform the author(s) of " + this.addon.getName() + " to fix this. Crafting Results with amounts of higher should be handled via the recipeOutput parameter!");
        }
        Slimefun.getRegistry().getEnabledSlimefunItems().add(this);
        this.loadItemHandlers();
        if (this instanceof Radioactive) {
            Slimefun.getRegistry().getRadioactiveItems().add(this);
        }
    }

    private void loadItemHandlers() {
        for (ItemHandler handler : this.itemhandlers.values()) {
            Optional<IncompatibleItemHandlerException> exception = handler.validate(this);
            if (exception.isPresent()) {
                throw exception.get();
            }
            this.checkForDeprecations(handler.getClass());
            if (!(handler instanceof GlobalItemHandler)) continue;
            SlimefunRegistry registry = Slimefun.getRegistry();
            registry.getGlobalItemHandlers(handler.getIdentifier()).add(handler);
        }
    }

    protected boolean isItemStackImmutable() {
        return true;
    }

    private void checkDependencies(@Nonnull SlimefunAddon addon) {
        if (!addon.hasDependency("Slimefun")) {
            throw new MissingDependencyException(addon, "Slimefun");
        }
    }

    private void checkForConflicts() {
        SlimefunItem conflictingItem = SlimefunItem.getById(this.id);
        if (conflictingItem != null) {
            throw new IdConflictException(this, conflictingItem);
        }
    }

    private void checkForDeprecations(@Nullable Class<?> c) {
        if (Slimefun.getUpdater().getBranch() == SlimefunBranch.DEVELOPMENT) {
            return;
        }
        if (c != null) {
            if (c.isAnnotationPresent(Deprecated.class)) {
                this.warn("The inherited Class \"" + c.getName() + "\" has been deprecated. Check the documentation for more details!");
            }
            for (Class<?> parent : c.getInterfaces()) {
                if (!parent.isAnnotationPresent(Deprecated.class)) continue;
                this.warn("The implemented Interface \"" + parent.getName() + "\" has been deprecated. Check the documentation for more details!");
            }
            this.checkForDeprecations(c.getSuperclass());
        }
    }

    public void setResearch(@Nullable Research research) {
        if (this.research != null) {
            this.research.getAffectedItems().remove(this);
        }
        if (research != null) {
            research.getAffectedItems().add(this);
        }
        this.research = research;
    }

    public void setRecipe(@Nonnull ItemStack[] recipe) {
        if (recipe == null || recipe.length != 9) {
            throw new IllegalArgumentException("Recipes must be of length 9");
        }
        this.recipe = recipe;
    }

    public void setRecipeType(@Nonnull RecipeType type) {
        Validate.notNull(type, "The RecipeType is not allowed to be null!");
        this.recipeType = type;
    }

    public void setItemGroup(@Nonnull ItemGroup itemGroup) {
        Validate.notNull(itemGroup, "The ItemGroup is not allowed to be null!");
        this.itemGroup.remove(this);
        itemGroup.add(this);
        this.itemGroup = itemGroup;
    }

    public void setRecipeOutput(@Nullable ItemStack output) {
        this.recipeOutput = output;
    }

    public boolean isUseableInWorkbench() {
        return this.useableInWorkbench;
    }

    @Nonnull
    public SlimefunItem setUseableInWorkbench(boolean useable) {
        this.useableInWorkbench = useable;
        return this;
    }

    public boolean isItem(@Nullable ItemStack item) {
        Optional<String> itemId;
        if (item == null) {
            return false;
        }
        if (item instanceof SlimefunItemStack) {
            SlimefunItemStack stack = (SlimefunItemStack)item;
            return this.getId().equals(stack.getItemId());
        }
        if (item.hasItemMeta() && (itemId = Slimefun.getItemDataService().getItemData(item)).isPresent()) {
            return this.getId().equals(itemId.get());
        }
        if (Slimefun.getRegistry().isBackwardsCompatible()) {
            boolean loreInsensitive = this instanceof Rechargeable || this instanceof SlimefunBackpack || this.id.equals("BROKEN_SPAWNER") || this.id.equals("REINFORCED_SPAWNER");
            return SlimefunUtils.isItemSimilar(item, this.itemStackTemplate, !loreInsensitive);
        }
        return false;
    }

    public void load() {
        if (!this.hidden) {
            this.itemGroup.add(this);
        }
        this.recipeType.register(this.recipe, this.getRecipeOutput());
    }

    public final void addItemHandler(ItemHandler ... handlers) {
        Validate.notEmpty(handlers, "You cannot add zero handlers...");
        Validate.noNullElements(handlers, "You cannot add any 'null' ItemHandler!");
        if (this.state != ItemState.UNREGISTERED) {
            throw new UnsupportedOperationException("You cannot add an ItemHandler after the SlimefunItem was registered.");
        }
        for (ItemHandler handler : handlers) {
            this.itemhandlers.put(handler.getIdentifier(), handler);
            if (!(handler instanceof BlockTicker)) continue;
            BlockTicker ticker = (BlockTicker)handler;
            this.ticking = true;
            Slimefun.getRegistry().getTickerBlocks().add(this.getId());
            this.blockTicker = ticker;
        }
    }

    public final void addItemSetting(ItemSetting<?> ... settings) {
        Validate.notEmpty(settings, "You cannot add zero settings...");
        Validate.noNullElements(settings, "You cannot add any 'null' ItemSettings!");
        if (this.state != ItemState.UNREGISTERED) {
            throw new UnsupportedOperationException("You cannot add an ItemSetting after the SlimefunItem was registered.");
        }
        if (this instanceof NotConfigurable) {
            throw new UnsupportedOperationException("This Item has been marked as NotConfigurable and cannot accept Item Settings!");
        }
        for (ItemSetting<?> setting : settings) {
            if (setting == null) continue;
            for (ItemSetting<?> existingSetting : this.itemSettings) {
                if (!existingSetting.getKey().equals(setting.getKey())) continue;
                throw new IllegalArgumentException("This Item has already an ItemSetting with this key: " + setting.getKey());
            }
            this.itemSettings.add(setting);
        }
    }

    public void preRegister() {
    }

    public void postRegister() {
    }

    public final void addOfficialWikipage(@Nonnull String page) {
        Validate.notNull(page, "Wiki page cannot be null.");
        this.wikiURL = Optional.of("https://github.com/Slimefun/Slimefun4/wiki/" + page);
    }

    @Nonnull
    public Optional<String> getWikipage() {
        return this.wikiURL;
    }

    @Nonnull
    public final String getItemName() {
        Optional<String> name;
        if (this.itemStackTemplate instanceof SlimefunItemStack && (name = ((SlimefunItemStack)this.itemStackTemplate).getItemMetaSnapshot().getDisplayName()).isPresent()) {
            return name.get();
        }
        return ItemUtils.getItemName(this.itemStackTemplate);
    }

    @Nonnull
    public Collection<ItemHandler> getHandlers() {
        return this.itemhandlers.values();
    }

    @ParametersAreNonnullByDefault
    public <T extends ItemHandler> boolean callItemHandler(Class<T> c, Consumer<T> callable) {
        Optional<ItemHandler> handler = this.itemhandlers.get(c);
        if (handler.isPresent()) {
            try {
                callable.accept((ItemHandler)c.cast(handler.get()));
            }
            catch (Exception | LinkageError x) {
                this.error("Could not pass \"" + c.getSimpleName() + "\" for " + this.toString(), x);
            }
            return true;
        }
        return false;
    }

    public boolean isTicking() {
        return this.ticking;
    }

    public String toString() {
        if (this.addon == null) {
            return this.getClass().getSimpleName() + " - '" + this.id + "'";
        }
        return this.getClass().getSimpleName() + " - '" + this.id + "' (" + this.addon.getName() + " v" + this.addon.getPluginVersion() + ")";
    }

    @Override
    @Nonnull
    public Collection<ItemStack> getDrops() {
        return Arrays.asList(this.itemStackTemplate.clone());
    }

    @Override
    @Nonnull
    public Collection<ItemStack> getDrops(Player p) {
        return this.getDrops();
    }

    @ParametersAreNonnullByDefault
    public void info(String message) {
        Validate.notNull(this.addon, "Cannot log a message for an unregistered item!");
        String msg = this.toString() + ": " + message;
        this.addon.getLogger().log(Level.INFO, msg);
    }

    @ParametersAreNonnullByDefault
    public void warn(String message) {
        Validate.notNull(this.addon, "Cannot send a warning for an unregistered item!");
        String msg = this.toString() + ": " + message;
        this.addon.getLogger().log(Level.WARNING, msg);
        if (this.addon.getBugTrackerURL() != null) {
            this.addon.getLogger().log(Level.WARNING, "You can report this warning here: {0}", this.addon.getBugTrackerURL());
        }
    }

    @ParametersAreNonnullByDefault
    public void error(String message, Throwable throwable) {
        Validate.notNull(this.addon, "Cannot send an error for an unregistered item!");
        this.addon.getLogger().log(Level.SEVERE, "Item \"{0}\" from {1} v{2} has caused an Error!", new Object[]{this.id, this.addon.getName(), this.addon.getPluginVersion()});
        if (this.addon.getBugTrackerURL() != null) {
            this.addon.getLogger().log(Level.SEVERE, "You can report it here: {0}", this.addon.getBugTrackerURL());
        }
        this.addon.getLogger().log(Level.SEVERE, message, throwable);
        if (throwable instanceof RuntimeException) {
            RuntimeException e = (RuntimeException)throwable;
            if (Slimefun.getMinecraftVersion() == MinecraftVersion.UNIT_TEST) {
                throw e;
            }
        }
    }

    @ParametersAreNonnullByDefault
    public void sendDeprecationWarning(Player player) {
        Validate.notNull(player, "The Player must not be null.");
        Slimefun.getLocalization().sendMessage((CommandSender)player, "messages.deprecated-item");
    }

    public boolean canUse(@Nonnull Player p, boolean sendMessage) {
        Validate.notNull(p, "The Player cannot be null!");
        if (this.getState() == ItemState.VANILLA_FALLBACK) {
            return true;
        }
        if (this.isDisabled()) {
            if (sendMessage) {
                Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.disabled-item", true);
            }
            return false;
        }
        if (!Slimefun.getWorldSettingsService().isEnabled(p.getWorld(), this)) {
            if (sendMessage) {
                Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.disabled-in-world", true);
            }
            return false;
        }
        if (!Slimefun.getPermissionsService().hasPermission((Permissible)p, this)) {
            if (sendMessage) {
                Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.no-permission", true);
            }
            return false;
        }
        if (this.hasResearch()) {
            Optional<PlayerProfile> profile = PlayerProfile.find((OfflinePlayer)p);
            if (!profile.isPresent()) {
                PlayerProfile.request((OfflinePlayer)p);
                return false;
            }
            if (!profile.get().hasUnlocked(this.getResearch())) {
                if (sendMessage && !(this instanceof VanillaItem)) {
                    Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.not-researched", true, s -> s.replace("%item%", this.getItemName()));
                }
                return false;
            }
            return true;
        }
        return true;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof SlimefunItem) {
            SlimefunItem item = (SlimefunItem)obj;
            return item.getId().equals(this.getId());
        }
        return false;
    }

    public final int hashCode() {
        return this.getId().hashCode();
    }

    @Nullable
    public static SlimefunItem getById(@Nonnull String id) {
        return Slimefun.getRegistry().getSlimefunItemIds().get(id);
    }

    @Nullable
    public static SlimefunItem getByItem(@Nullable ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return null;
        }
        if (item instanceof SlimefunItemStack) {
            SlimefunItemStack stack = (SlimefunItemStack)item;
            return SlimefunItem.getById(stack.getItemId());
        }
        Optional<String> itemID = Slimefun.getItemDataService().getItemData(item);
        if (itemID.isPresent()) {
            return SlimefunItem.getById(itemID.get());
        }
        if (Slimefun.getRegistry().isBackwardsCompatible()) {
            ItemStackWrapper wrapper = ItemStackWrapper.wrap(item);
            for (SlimefunItem sfi : Slimefun.getRegistry().getAllSlimefunItems()) {
                if (!sfi.isItem(wrapper)) continue;
                Slimefun.getItemDataService().setItemData(item, sfi.getId());
                return sfi;
            }
        }
        return null;
    }
}

