/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners.entity;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.core.attributes.RandomMobDrop;
import io.github.thebusybiscuit.slimefun4.core.handlers.EntityKillHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.misc.BasicCircuitBoard;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MobDropListener
implements Listener {
    public MobDropListener(@Nonnull Slimefun plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onEntityKill(EntityDeathEvent e) {
        if (e.getEntity().getKiller() != null) {
            SlimefunItem sfItem;
            Player p = e.getEntity().getKiller();
            ItemStack item = p.getInventory().getItemInMainHand();
            Set<ItemStack> customDrops = Slimefun.getRegistry().getMobDrops().get(e.getEntityType());
            if (customDrops != null && !customDrops.isEmpty()) {
                for (ItemStack drop : customDrops) {
                    if (!this.canDrop(p, drop)) continue;
                    e.getDrops().add(drop.clone());
                }
            }
            if (item.getType() != Material.AIR && (sfItem = SlimefunItem.getByItem(item)) != null && sfItem.canUse(p, true)) {
                sfItem.callItemHandler(EntityKillHandler.class, handler -> handler.onKill(e, (Entity)e.getEntity(), p, item));
            }
        }
    }

    private boolean canDrop(@Nonnull Player p, @Nonnull ItemStack item) {
        SlimefunItem sfItem = SlimefunItem.getByItem(item);
        if (sfItem == null) {
            return true;
        }
        if (sfItem.canUse(p, true)) {
            if (sfItem instanceof RandomMobDrop) {
                RandomMobDrop randomMobDrop = (RandomMobDrop)((Object)sfItem);
                int random = ThreadLocalRandom.current().nextInt(100);
                if (randomMobDrop.getMobDropChance() <= random) {
                    return false;
                }
            }
            if (sfItem instanceof BasicCircuitBoard) {
                BasicCircuitBoard basicCircuitBoard = (BasicCircuitBoard)sfItem;
                return basicCircuitBoard.isDroppedFromGolems();
            }
            return true;
        }
        return false;
    }
}

