/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.integrations;

import com.gmail.nossr50.events.fake.FakeBlockBreakEvent;
import com.gmail.nossr50.util.skills.SkillUtils;
import dev.lone.itemsadder.api.ItemsAdder;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.integrations.ClearLagIntegration;
import io.github.thebusybiscuit.slimefun4.integrations.McMMOIntegration;
import io.github.thebusybiscuit.slimefun4.integrations.OrebfuscatorIntegration;
import io.github.thebusybiscuit.slimefun4.integrations.PlaceholderAPIIntegration;
import io.github.thebusybiscuit.slimefun4.integrations.WorldEditIntegration;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.ProtectionManager;
import java.util.function.Consumer;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class IntegrationsManager {
    protected final Slimefun plugin;
    private ProtectionManager protectionManager;
    private boolean isEnabled = false;
    private boolean isPlaceholderAPIInstalled = false;
    private boolean isWorldEditInstalled = false;
    private boolean isMcMMOInstalled = false;
    private boolean isClearLagInstalled = false;
    private boolean isItemsAdderInstalled = false;
    private boolean isOrebfuscatorInstalled = false;

    public IntegrationsManager(@Nonnull Slimefun plugin) {
        this.plugin = plugin;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public final void start() {
        if (this.isEnabled) {
            throw new UnsupportedOperationException("All integrations have already been loaded.");
        }
        this.isEnabled = true;
        this.onServerLoad();
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, this::onServerStart);
    }

    private void onServerLoad() {
        this.load("PlaceholderAPI", integration -> {
            new PlaceholderAPIIntegration(this.plugin).register();
            this.isPlaceholderAPIInstalled = true;
        });
        this.load("WorldEdit", integration -> {
            new WorldEditIntegration().register();
            this.isWorldEditInstalled = true;
        });
        this.load("mcMMO", integration -> {
            new McMMOIntegration(this.plugin).register();
            this.isMcMMOInstalled = true;
        });
        this.load("ClearLag", integration -> {
            new ClearLagIntegration(this.plugin).register();
            this.isClearLagInstalled = true;
        });
        this.load("ItemsAdder", integration -> {
            this.isItemsAdderInstalled = true;
        });
    }

    private void onServerStart() {
        try {
            this.protectionManager = new ProtectionManager((Plugin)this.plugin);
        }
        catch (Exception | LinkageError x) {
            Slimefun.logger().log(Level.WARNING, x, () -> "Failed to load Protection plugin integrations for Slimefun v" + Slimefun.getVersion());
        }
        this.load("Orebfuscator", integration -> {
            new OrebfuscatorIntegration(this.plugin).register();
            this.isOrebfuscatorInstalled = true;
        });
    }

    @ParametersAreNonnullByDefault
    protected void logError(String name, Throwable throwable) {
        Plugin externalPlugin = Bukkit.getPluginManager().getPlugin(name);
        if (externalPlugin != null) {
            String version = externalPlugin.getDescription().getVersion();
            Slimefun.logger().log(Level.WARNING, "Is {0} v{1} up to date?", new Object[]{name, version});
            Slimefun.logger().log(Level.SEVERE, throwable, () -> "An unknown error was detected while interacting with \"" + name + " v" + version + "\"");
        } else {
            Slimefun.logger().log(Level.SEVERE, throwable, () -> "An unknown error was detected while interacting with the plugin \"" + name + "\"");
        }
    }

    private void load(@Nonnull String pluginName, @Nonnull Consumer<Plugin> consumer) {
        Plugin integration = this.plugin.getServer().getPluginManager().getPlugin(pluginName);
        if (integration != null && integration.isEnabled()) {
            String version = integration.getDescription().getVersion();
            Slimefun.logger().log(Level.INFO, "Hooked into Plugin: {0} v{1}", new Object[]{pluginName, version});
            try {
                consumer.accept(integration);
            }
            catch (Exception | LinkageError x) {
                Slimefun.logger().log(Level.WARNING, "Maybe consider updating {0} or Slimefun?", pluginName);
                Slimefun.logger().log(Level.WARNING, x, () -> "Failed to hook into " + pluginName + " v" + version);
            }
        }
    }

    @Nonnull
    public ProtectionManager getProtectionManager() {
        return this.protectionManager;
    }

    public boolean isEventFaked(@Nonnull Event event) {
        return this.isMcMMOInstalled && event instanceof FakeBlockBreakEvent;
    }

    public boolean isCustomBlock(@Nonnull Block block) {
        if (this.isItemsAdderInstalled) {
            try {
                return ItemsAdder.isCustomBlock((Block)block);
            }
            catch (Exception | LinkageError x) {
                this.logError("ItemsAdder", x);
            }
        }
        return false;
    }

    public boolean isCustomItem(@Nonnull ItemStack item) {
        if (this.isItemsAdderInstalled) {
            try {
                return ItemsAdder.isCustomItem((ItemStack)item);
            }
            catch (Exception | LinkageError x) {
                this.logError("ItemsAdder", x);
            }
        }
        return false;
    }

    public void removeTemporaryEnchantments(@Nonnull ItemStack item) {
        if (this.isMcMMOInstalled) {
            try {
                SkillUtils.removeAbilityBuff((ItemStack)item);
            }
            catch (Exception | LinkageError x) {
                this.logError("mcMMO", x);
            }
        }
    }

    public boolean isPlaceholderAPIInstalled() {
        return this.isPlaceholderAPIInstalled;
    }

    public boolean isWorldEditInstalled() {
        return this.isWorldEditInstalled;
    }

    public boolean isMcMMOInstalled() {
        return this.isMcMMOInstalled;
    }

    public boolean isClearLagInstalled() {
        return this.isClearLagInstalled;
    }

    public boolean isItemsAdderInstalled() {
        return this.isItemsAdderInstalled;
    }

    public boolean isOrebfuscatorInstalled() {
        return this.isOrebfuscatorInstalled;
    }
}

