/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.utils.tags;

import io.github.thebusybiscuit.slimefun4.api.exceptions.TagMisconfigurationException;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.utils.tags.TagParser;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.plugin.Plugin;

public enum SlimefunTag implements Tag<Material>
{
    ORES,
    STONE_ORES,
    DEEPSLATE_ORES,
    NETHER_ORES,
    RAW_METALS,
    SHULKER_BOXES,
    COMMAND_BLOCKS,
    SPAWN_EGGS,
    MUSHROOMS,
    LEATHER_ARMOR,
    GLASS,
    GLASS_BLOCKS,
    GLASS_PANES,
    TORCHES,
    TERRACOTTA,
    ICE_VARIANTS,
    STONE_VARIANTS,
    DIRT_VARIANTS,
    FUNGUS_SOIL,
    MANGROVE_BASE_BLOCKS,
    CONCRETE_POWDERS,
    PRESSURE_PLATES,
    TALL_FLOWERS,
    SENSITIVE_MATERIALS,
    FLUID_SENSITIVE_MATERIALS,
    UNBREAKABLE_MATERIALS,
    BLOCK_PLACER_IGNORED_MATERIALS,
    EXPLOSIVE_SHOVEL_BLOCKS,
    PICKAXE_OF_VEIN_MINING_BLOCKS,
    PICKAXE_OF_THE_SEEKER_BLOCKS,
    SMELTERS_PICKAXE_BLOCKS,
    INDUSTRIAL_MINER_ORES,
    MINER_TALISMAN_TRIGGERS,
    FARMER_TALISMAN_TRIGGERS,
    CROP_GROWTH_ACCELERATOR_BLOCKS,
    CLIMBING_PICK_STRONG_SURFACES,
    CLIMBING_PICK_WEAK_SURFACES,
    CLIMBING_PICK_SURFACES,
    CAVEMAN_TALISMAN_TRIGGERS,
    ENHANCED_FURNACE_LUCK_MATERIALS,
    GRAVITY_AFFECTED_BLOCKS,
    WOOL_CARPETS,
    AUTO_CRAFTER_SUPPORTED_STORAGE_BLOCKS,
    CARGO_SUPPORTED_STORAGE_BLOCKS,
    TILE_ENTITIES;

    private static final Map<String, SlimefunTag> nameLookup;
    private static final SlimefunTag[] valuesCache;
    private final NamespacedKey key;
    private final Set<Material> includedMaterials = EnumSet.noneOf(Material.class);
    private final Set<Tag<Material>> additionalTags = new HashSet<Tag<Material>>();

    private SlimefunTag() {
        this.key = new NamespacedKey((Plugin)Slimefun.instance(), this.name().toLowerCase(Locale.ROOT));
    }

    public void reload() throws TagMisconfigurationException {
        new TagParser(this).parse(this, (materials, tags) -> {
            this.includedMaterials.clear();
            this.includedMaterials.addAll((Collection<Material>)materials);
            this.additionalTags.clear();
            this.additionalTags.addAll((Collection<Tag<Material>>)tags);
        });
    }

    public static void reloadAll() throws TagMisconfigurationException {
        for (SlimefunTag tag : valuesCache) {
            tag.reload();
        }
    }

    @Nonnull
    public NamespacedKey getKey() {
        return this.key;
    }

    public boolean isTagged(@Nonnull Material item) {
        if (this.includedMaterials.contains(item)) {
            return true;
        }
        for (Tag<Material> tag : this.additionalTags) {
            if (!tag.isTagged((Keyed)item)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public Set<Material> getValues() {
        if (this.additionalTags.isEmpty()) {
            return Collections.unmodifiableSet(this.includedMaterials);
        }
        EnumSet<Material> materials = EnumSet.noneOf(Material.class);
        materials.addAll(this.includedMaterials);
        for (Tag<Material> tag : this.additionalTags) {
            materials.addAll(tag.getValues());
        }
        return materials;
    }

    public boolean isEmpty() {
        if (!this.includedMaterials.isEmpty()) {
            return false;
        }
        return this.getValues().isEmpty();
    }

    @Nonnull
    public Set<Tag<Material>> getSubTags() {
        return Collections.unmodifiableSet(this.additionalTags);
    }

    @Nonnull
    public Material[] toArray() {
        return this.getValues().toArray(new Material[0]);
    }

    @Nonnull
    public Stream<Material> stream() {
        return this.getValues().stream();
    }

    @Nullable
    public static SlimefunTag getTag(@Nonnull String value) {
        Validate.notNull(value, "A tag cannot be null!");
        return nameLookup.get(value);
    }

    static {
        nameLookup = new HashMap<String, SlimefunTag>();
        for (SlimefunTag tag : valuesCache = SlimefunTag.values()) {
            nameLookup.put(tag.name(), tag);
        }
    }
}

