/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.config.Config;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CustomTextureService {
    private final Config config;
    private String version = null;
    private boolean modified = false;

    public CustomTextureService(@Nonnull Config config) {
        this.config = config;
        config.getConfiguration().options().header("This file is used to assign items from Slimefun or any of its addons\nthe 'CustomModelData' NBT tag. This can be used in conjunction with a custom resource pack\nto give items custom textures.\n0 means there is no data assigned to that item.\n\nThere is no official Slimefun resource pack at the moment.");
        config.getConfiguration().options().copyHeader(true);
    }

    public void register(@Nonnull Collection<SlimefunItem> items, boolean save) {
        Validate.notEmpty(items, "items must neither be null or empty.");
        this.loadDefaultValues();
        for (SlimefunItem item : items) {
            if (item == null) continue;
            this.config.setDefaultValue(item.getId(), 0);
            if (this.config.getInt(item.getId()) == 0) continue;
            this.modified = true;
        }
        this.version = this.config.getString("version");
        if (save) {
            this.config.save();
        }
    }

    private void loadDefaultValues() {
        InputStream inputStream = Slimefun.class.getResourceAsStream("/item-models.yml");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            YamlConfiguration cfg = YamlConfiguration.loadConfiguration((Reader)reader);
            for (String key : cfg.getKeys(false)) {
                this.config.setDefaultValue(key, cfg.getInt(key));
            }
        }
        catch (Exception e) {
            Slimefun.logger().log(Level.SEVERE, "Failed to load default item-models.yml file", e);
        }
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public boolean isActive() {
        return this.modified;
    }

    public int getModelData(@Nonnull String id) {
        Validate.notNull(id, "Cannot get the ModelData for 'null'");
        return this.config.getInt(id);
    }

    public void setTexture(@Nonnull ItemStack item, @Nonnull String id) {
        Validate.notNull(item, "The Item cannot be null!");
        Validate.notNull(id, "Cannot store null on an Item!");
        ItemMeta im = item.getItemMeta();
        this.setTexture(im, id);
        item.setItemMeta(im);
    }

    public void setTexture(@Nonnull ItemMeta im, @Nonnull String id) {
        Validate.notNull(im, "The ItemMeta cannot be null!");
        Validate.notNull(id, "Cannot store null on an ItemMeta!");
        int data = this.getModelData(id);
        im.setCustomModelData(data == 0 ? null : Integer.valueOf(data));
    }
}

