/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.networks.energy;

import io.github.thebusybiscuit.slimefun4.api.ErrorReport;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.network.Network;
import io.github.thebusybiscuit.slimefun4.api.network.NetworkComponent;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetProvider;
import io.github.thebusybiscuit.slimefun4.core.attributes.HologramOwner;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class EnergyNet
extends Network
implements HologramOwner {
    private static final int RANGE = 6;
    private final Map<Location, EnergyNetProvider> generators = new HashMap<Location, EnergyNetProvider>();
    private final Map<Location, EnergyNetComponent> capacitors = new HashMap<Location, EnergyNetComponent>();
    private final Map<Location, EnergyNetComponent> consumers = new HashMap<Location, EnergyNetComponent>();

    protected EnergyNet(@Nonnull Location l) {
        super(Slimefun.getNetworkManager(), l);
    }

    @Override
    public int getRange() {
        return 6;
    }

    @Nonnull
    public Map<Location, EnergyNetProvider> getGenerators() {
        return Collections.unmodifiableMap(this.generators);
    }

    @Nonnull
    public Map<Location, EnergyNetComponent> getCapacitors() {
        return Collections.unmodifiableMap(this.capacitors);
    }

    @Nonnull
    public Map<Location, EnergyNetComponent> getConsumers() {
        return Collections.unmodifiableMap(this.consumers);
    }

    @Override
    @Nonnull
    public String getId() {
        return "ENERGY_NETWORK";
    }

    @Override
    public NetworkComponent classifyLocation(@Nonnull Location l) {
        if (this.regulator.equals((Object)l)) {
            return NetworkComponent.REGULATOR;
        }
        EnergyNetComponent component = EnergyNet.getComponent(l);
        if (component == null) {
            return null;
        }
        return switch (component.getEnergyComponentType()) {
            case EnergyNetComponentType.CONNECTOR, EnergyNetComponentType.CAPACITOR -> NetworkComponent.CONNECTOR;
            case EnergyNetComponentType.CONSUMER, EnergyNetComponentType.GENERATOR -> NetworkComponent.TERMINUS;
            default -> null;
        };
    }

    @Override
    public void onClassificationChange(Location l, NetworkComponent from, NetworkComponent to) {
        EnergyNetComponent component;
        if (from == NetworkComponent.TERMINUS) {
            this.generators.remove(l);
            this.consumers.remove(l);
        }
        if ((component = EnergyNet.getComponent(l)) != null) {
            switch (component.getEnergyComponentType()) {
                case CAPACITOR: {
                    this.capacitors.put(l, component);
                    break;
                }
                case CONSUMER: {
                    this.consumers.put(l, component);
                    break;
                }
                case GENERATOR: {
                    if (component instanceof EnergyNetProvider) {
                        EnergyNetProvider provider = (EnergyNetProvider)component;
                        this.generators.put(l, provider);
                        break;
                    }
                    if (!(component instanceof SlimefunItem)) break;
                    SlimefunItem item = (SlimefunItem)((Object)component);
                    item.warn("This Item is marked as a GENERATOR but does not implement the interface EnergyNetProvider!");
                    break;
                }
            }
        }
    }

    public void tick(@Nonnull Block b) {
        AtomicLong timestamp = new AtomicLong(Slimefun.getProfiler().newEntry());
        if (!this.regulator.equals((Object)b.getLocation())) {
            this.updateHologram(b, "&4Multiple Energy Regulators connected");
            Slimefun.getProfiler().closeEntry(b.getLocation(), SlimefunItems.ENERGY_REGULATOR.getItem(), timestamp.get());
            return;
        }
        super.tick();
        if (this.connectorNodes.isEmpty() && this.terminusNodes.isEmpty()) {
            this.updateHologram(b, "&4No Energy Network found");
        } else {
            int supply;
            int remainingEnergy = supply = this.tickAllGenerators(timestamp::getAndAdd) + this.tickAllCapacitors();
            int demand = 0;
            for (Map.Entry<Location, EnergyNetComponent> entry : this.consumers.entrySet()) {
                Location loc = entry.getKey();
                EnergyNetComponent component = entry.getValue();
                int capacity = component.getCapacity();
                int charge = component.getCharge(loc);
                if (charge >= capacity) continue;
                int availableSpace = capacity - charge;
                demand += availableSpace;
                if (remainingEnergy <= 0) continue;
                if (remainingEnergy > availableSpace) {
                    component.setCharge(loc, capacity);
                    remainingEnergy -= availableSpace;
                    continue;
                }
                component.setCharge(loc, charge + remainingEnergy);
                remainingEnergy = 0;
            }
            this.storeRemainingEnergy(remainingEnergy);
            this.updateHologram(b, supply, demand);
        }
        Slimefun.getProfiler().closeEntry(b.getLocation(), SlimefunItems.ENERGY_REGULATOR.getItem(), timestamp.get());
    }

    private void storeRemainingEnergy(int remainingEnergy) {
        int capacity;
        EnergyNetComponent component;
        Location loc;
        for (Map.Entry<Location, EnergyNetComponent> entry : this.capacitors.entrySet()) {
            loc = entry.getKey();
            component = entry.getValue();
            if (remainingEnergy > 0) {
                capacity = component.getCapacity();
                if (remainingEnergy > capacity) {
                    component.setCharge(loc, capacity);
                    remainingEnergy -= capacity;
                    continue;
                }
                component.setCharge(loc, remainingEnergy);
                remainingEnergy = 0;
                continue;
            }
            component.setCharge(loc, 0);
        }
        for (Map.Entry<Location, EnergyNetComponent> entry : this.generators.entrySet()) {
            loc = entry.getKey();
            component = (EnergyNetProvider)entry.getValue();
            capacity = component.getCapacity();
            if (remainingEnergy > 0) {
                if (remainingEnergy > capacity) {
                    component.setCharge(loc, capacity);
                    remainingEnergy -= capacity;
                    continue;
                }
                component.setCharge(loc, remainingEnergy);
                remainingEnergy = 0;
                continue;
            }
            component.setCharge(loc, 0);
        }
    }

    private int tickAllGenerators(@Nonnull LongConsumer timings) {
        HashSet<Location> explodedBlocks = new HashSet<Location>();
        int supply = 0;
        for (Map.Entry<Location, EnergyNetProvider> entry : this.generators.entrySet()) {
            long timestamp = Slimefun.getProfiler().newEntry();
            Location loc = entry.getKey();
            EnergyNetProvider provider = entry.getValue();
            SlimefunItem item = (SlimefunItem)((Object)provider);
            try {
                Config data = BlockStorage.getLocationInfo(loc);
                int energy = provider.getGeneratedOutput(loc, data);
                if (provider.isChargeable()) {
                    energy += provider.getCharge(loc, data);
                }
                if (provider.willExplode(loc, data)) {
                    explodedBlocks.add(loc);
                    BlockStorage.clearBlockInfo(loc);
                    Slimefun.runSync(() -> {
                        loc.getBlock().setType(Material.LAVA);
                        loc.getWorld().createExplosion(loc, 0.0f, false);
                    });
                } else {
                    supply += energy;
                }
            }
            catch (Exception | LinkageError throwable) {
                explodedBlocks.add(loc);
                new ErrorReport<Throwable>(throwable, loc, item);
            }
            long time = Slimefun.getProfiler().closeEntry(loc, item, timestamp);
            timings.accept(time);
        }
        if (!explodedBlocks.isEmpty()) {
            this.generators.keySet().removeAll(explodedBlocks);
        }
        return supply;
    }

    private int tickAllCapacitors() {
        int supply = 0;
        for (Map.Entry<Location, EnergyNetComponent> entry : this.capacitors.entrySet()) {
            supply += entry.getValue().getCharge(entry.getKey());
        }
        return supply;
    }

    private void updateHologram(@Nonnull Block b, double supply, double demand) {
        if (demand > supply) {
            String netLoss = NumberUtils.getCompactDouble(demand - supply);
            this.updateHologram(b, "&4&l- &c" + netLoss + " &7J &e\u26a1");
        } else {
            String netGain = NumberUtils.getCompactDouble(supply - demand);
            this.updateHologram(b, "&2&l+ &a" + netGain + " &7J &e\u26a1");
        }
    }

    @Nullable
    private static EnergyNetComponent getComponent(@Nonnull Location l) {
        SlimefunItem item = BlockStorage.check(l);
        if (item instanceof EnergyNetComponent) {
            EnergyNetComponent component = (EnergyNetComponent)((Object)item);
            return component;
        }
        return null;
    }

    @Nullable
    public static EnergyNet getNetworkFromLocation(@Nonnull Location l) {
        return Slimefun.getNetworkManager().getNetworkFromLocation(l, EnergyNet.class).orElse(null);
    }

    @Nonnull
    public static EnergyNet getNetworkFromLocationOrCreate(@Nonnull Location l) {
        Optional<EnergyNet> energyNetwork = Slimefun.getNetworkManager().getNetworkFromLocation(l, EnergyNet.class);
        if (energyNetwork.isPresent()) {
            return energyNetwork.get();
        }
        EnergyNet network = new EnergyNet(l);
        Slimefun.getNetworkManager().registerNetwork(network);
        return network;
    }
}

