/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.blocks;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.handlers.VanillaInventoryDropHandler;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.inventory.InvUtils;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class OutputChest
extends SlimefunItem {
    private static final BlockFace[] possibleFaces = new BlockFace[]{BlockFace.UP, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};

    @ParametersAreNonnullByDefault
    public OutputChest(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.addItemHandler(new VanillaInventoryDropHandler<Chest>(Chest.class));
    }

    @Nonnull
    public static Optional<Inventory> findOutputChestFor(@Nonnull Block b, @Nonnull ItemStack item) {
        Validate.notNull(b, "The target block must not be null!");
        Validate.notNull(item, "The ItemStack should not be null!");
        for (BlockFace face : possibleFaces) {
            Chest chest;
            Inventory inv;
            BlockState state;
            SlimefunItem slimefunItem;
            Block potentialOutput = b.getRelative(face);
            if (potentialOutput.getType() != Material.CHEST || !((slimefunItem = BlockStorage.check(potentialOutput)) instanceof OutputChest) || slimefunItem.isDisabledIn(b.getWorld()) || !((state = PaperLib.getBlockState(potentialOutput, false).getState()) instanceof Chest) || !InvUtils.fits(inv = (chest = (Chest)state).getInventory(), item, new int[0])) continue;
            return Optional.of(inv);
        }
        return Optional.empty();
    }
}

