/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.items.groups;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class LockedItemGroup
extends ItemGroup {
    private final NamespacedKey[] keys;
    private final Set<ItemGroup> parents = new HashSet<ItemGroup>();

    @ParametersAreNonnullByDefault
    public LockedItemGroup(NamespacedKey key, ItemStack item, NamespacedKey ... parents) {
        this(key, item, 3, parents);
    }

    @ParametersAreNonnullByDefault
    public LockedItemGroup(NamespacedKey key, ItemStack item, int tier, NamespacedKey ... parents) {
        super(key, item, tier);
        Validate.noNullElements(parents, "A LockedItemGroup must not have any 'null' parents!");
        this.keys = parents;
    }

    @Override
    public void register(@Nonnull SlimefunAddon addon) {
        super.register(addon);
        ArrayList<NamespacedKey> namespacedKeys = new ArrayList<NamespacedKey>();
        for (NamespacedKey key : this.keys) {
            if (key == null) continue;
            namespacedKeys.add(key);
        }
        for (ItemGroup itemGroup : Slimefun.getRegistry().getAllItemGroups()) {
            if (!namespacedKeys.remove(itemGroup.getKey())) continue;
            this.addParent(itemGroup);
        }
        for (NamespacedKey key : namespacedKeys) {
            Slimefun.logger().log(Level.INFO, "Parent \"{0}\" for LockedItemGroup \"{1}\" was not found, probably just disabled.", new Object[]{key, this.getKey()});
        }
    }

    @Nonnull
    public Set<ItemGroup> getParents() {
        return this.parents;
    }

    public void addParent(ItemGroup group) {
        if (group == this || group == null) {
            throw new IllegalArgumentException("ItemGroup '" + this.item.getItemMeta().getDisplayName() + "' cannot be a parent of itself or have a 'null' parent.");
        }
        this.parents.add(group);
    }

    public void removeParent(@Nonnull ItemGroup group) {
        this.parents.remove(group);
    }

    public boolean hasUnlocked(@Nonnull Player p, @Nonnull PlayerProfile profile) {
        Validate.notNull(p, "The player cannot be null!");
        Validate.notNull(profile, "The Profile cannot be null!");
        for (ItemGroup parent : this.parents) {
            for (SlimefunItem item : parent.getItems()) {
                if (item.isDisabledIn(p.getWorld()) || !item.hasResearch() || profile.hasUnlocked(item.getResearch())) continue;
                return false;
            }
        }
        return true;
    }
}

