/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.autocrafters;

import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.autocrafters.AbstractRecipe;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.AsyncRecipeChoiceTask;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

class VanillaRecipe
extends AbstractRecipe {
    private final int[] slots = new int[]{11, 12, 13, 20, 21, 22, 29, 30, 31};
    private final Recipe recipe;

    VanillaRecipe(@Nonnull ShapelessRecipe recipe) {
        super(new ArrayList<Predicate<ItemStack>>(recipe.getChoiceList()), recipe.getResult());
        this.recipe = recipe;
    }

    VanillaRecipe(@Nonnull ShapedRecipe recipe) {
        super(VanillaRecipe.getChoices(recipe), recipe.getResult());
        this.recipe = recipe;
    }

    @Nonnull
    private static Collection<Predicate<ItemStack>> getChoices(@Nonnull ShapedRecipe recipe) {
        ArrayList<Predicate<ItemStack>> choices = new ArrayList<Predicate<ItemStack>>();
        for (String row : recipe.getShape()) {
            for (char c : row.toCharArray()) {
                RecipeChoice choice = (RecipeChoice)recipe.getChoiceMap().get(Character.valueOf(c));
                if (choice == null) continue;
                choices.add((Predicate<ItemStack>)choice);
            }
        }
        return choices;
    }

    @Nonnull
    private static RecipeChoice[] getShape(@Nonnull Recipe recipe) {
        return Slimefun.getMinecraftRecipeService().getRecipeShape(recipe);
    }

    @Override
    public void show(@Nonnull ChestMenu menu, @Nonnull AsyncRecipeChoiceTask task) {
        RecipeChoice recipeChoice;
        Validate.notNull(menu, "The ChestMenu cannot be null!");
        Validate.notNull(task, "The RecipeChoiceTask cannot be null!");
        menu.replaceExistingItem(24, this.getResult().clone());
        menu.addMenuClickHandler(24, ChestMenuUtils.getEmptyClickHandler());
        RecipeChoice[] choices = Slimefun.getMinecraftRecipeService().getRecipeShape(this.recipe);
        ItemStack[] items = new ItemStack[9];
        if (choices.length == 1 && (recipeChoice = choices[0]) instanceof RecipeChoice.MaterialChoice) {
            RecipeChoice.MaterialChoice materialChoice = (RecipeChoice.MaterialChoice)recipeChoice;
            items[4] = new ItemStack((Material)materialChoice.getChoices().get(0));
            if (materialChoice.getChoices().size() > 1) {
                task.add(this.slots[4], materialChoice);
            }
        } else {
            for (int i = 0; i < choices.length; ++i) {
                RecipeChoice recipeChoice2 = choices[i];
                if (!(recipeChoice2 instanceof RecipeChoice.MaterialChoice)) continue;
                RecipeChoice.MaterialChoice materialChoice = (RecipeChoice.MaterialChoice)recipeChoice2;
                items[i] = new ItemStack((Material)materialChoice.getChoices().get(0));
                if (materialChoice.getChoices().size() <= 1) continue;
                task.add(this.slots[i], materialChoice);
            }
        }
        for (int i = 0; i < 9; ++i) {
            menu.replaceExistingItem(this.slots[i], items[i]);
            menu.addMenuClickHandler(this.slots[i], ChestMenuUtils.getEmptyClickHandler());
        }
    }

    public String toString() {
        Recipe recipe = this.recipe;
        if (recipe instanceof Keyed) {
            Keyed keyed = (Keyed)recipe;
            return keyed.getKey().toString();
        }
        return "invalid-recipe";
    }
}

