/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Dispenser;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class OreCrusher
extends MultiBlockMachine {
    private final DoubleOreSetting doubleOres = new DoubleOreSetting(this);

    @ParametersAreNonnullByDefault
    public OreCrusher(ItemGroup itemGroup, SlimefunItemStack item) {
        super(itemGroup, item, new ItemStack[]{null, null, null, null, new ItemStack(Material.NETHER_BRICK_FENCE), null, new ItemStack(Material.IRON_BARS), new CustomItemStack(Material.DISPENSER, "Dispenser (Facing up)", new String[0]), new ItemStack(Material.IRON_BARS)}, BlockFace.SELF);
        this.addItemSetting(this.doubleOres);
    }

    @Override
    protected void registerDefaultRecipes(List<ItemStack> recipes) {
        recipes.add(new ItemStack(Material.COBBLESTONE, 8));
        recipes.add(new ItemStack(Material.SAND, 1));
        recipes.add(SlimefunItems.GOLD_4K);
        recipes.add(SlimefunItems.GOLD_DUST);
        recipes.add(SlimefunItems.GOLD_6K);
        recipes.add(new SlimefunItemStack(SlimefunItems.GOLD_DUST, 2));
        recipes.add(SlimefunItems.GOLD_8K);
        recipes.add(new SlimefunItemStack(SlimefunItems.GOLD_DUST, 2));
        recipes.add(SlimefunItems.GOLD_10K);
        recipes.add(new SlimefunItemStack(SlimefunItems.GOLD_DUST, 3));
        recipes.add(SlimefunItems.GOLD_12K);
        recipes.add(new SlimefunItemStack(SlimefunItems.GOLD_DUST, 3));
        recipes.add(SlimefunItems.GOLD_14K);
        recipes.add(new SlimefunItemStack(SlimefunItems.GOLD_DUST, 4));
        recipes.add(SlimefunItems.GOLD_16K);
        recipes.add(new SlimefunItemStack(SlimefunItems.GOLD_DUST, 4));
        recipes.add(SlimefunItems.GOLD_18K);
        recipes.add(new SlimefunItemStack(SlimefunItems.GOLD_DUST, 5));
        recipes.add(SlimefunItems.GOLD_20K);
        recipes.add(new SlimefunItemStack(SlimefunItems.GOLD_DUST, 5));
        recipes.add(SlimefunItems.GOLD_22K);
        recipes.add(new SlimefunItemStack(SlimefunItems.GOLD_DUST, 6));
        recipes.add(SlimefunItems.GOLD_24K);
        recipes.add(new SlimefunItemStack(SlimefunItems.GOLD_DUST, 6));
        recipes.add(new ItemStack(Material.GRAVEL));
        recipes.add(new ItemStack(Material.SAND));
        recipes.add(new ItemStack(Material.MAGMA_BLOCK));
        recipes.add(SlimefunItems.SULFATE);
        recipes.add(SlimefunItems.CARBON);
        recipes.add(new ItemStack(Material.COAL, 8));
        recipes.add(SlimefunItems.COMPRESSED_CARBON);
        recipes.add(new SlimefunItemStack(SlimefunItems.CARBON, 4));
    }

    public boolean isOreDoublingEnabled() {
        return (Boolean)this.doubleOres.getValue();
    }

    @Override
    public void postRegister() {
        super.postRegister();
        this.displayRecipes.addAll(Arrays.asList(new ItemStack(Material.COAL_ORE), this.doubleOres.getCoal(), new ItemStack(Material.LAPIS_ORE), this.doubleOres.getLapisLazuli(), new ItemStack(Material.REDSTONE_ORE), this.doubleOres.getRedstone(), new ItemStack(Material.DIAMOND_ORE), this.doubleOres.getDiamond(), new ItemStack(Material.EMERALD_ORE), this.doubleOres.getEmerald(), new ItemStack(Material.NETHER_QUARTZ_ORE), this.doubleOres.getNetherQuartz()));
        this.displayRecipes.add(new ItemStack(Material.NETHER_GOLD_ORE));
        this.displayRecipes.add(this.doubleOres.getGoldNuggets());
        this.displayRecipes.add(new ItemStack(Material.GILDED_BLACKSTONE));
        this.displayRecipes.add(this.doubleOres.getGoldNuggets());
        if (Slimefun.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_17)) {
            this.displayRecipes.add(new ItemStack(Material.RAW_IRON));
            this.displayRecipes.add(SlimefunItems.IRON_DUST);
            this.displayRecipes.add(new ItemStack(Material.RAW_COPPER));
            this.displayRecipes.add(SlimefunItems.COPPER_DUST);
            this.displayRecipes.add(new ItemStack(Material.RAW_GOLD));
            this.displayRecipes.add(SlimefunItems.GOLD_DUST);
        }
        if (Slimefun.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_17)) {
            this.displayRecipes.addAll(Arrays.asList(new ItemStack(Material.DEEPSLATE_COAL_ORE), this.doubleOres.getCoal(), new ItemStack(Material.DEEPSLATE_LAPIS_ORE), this.doubleOres.getLapisLazuli(), new ItemStack(Material.DEEPSLATE_REDSTONE_ORE), this.doubleOres.getRedstone(), new ItemStack(Material.DEEPSLATE_DIAMOND_ORE), this.doubleOres.getDiamond(), new ItemStack(Material.DEEPSLATE_EMERALD_ORE), this.doubleOres.getEmerald()));
            this.displayRecipes.add(new ItemStack(Material.DEEPSLATE_IRON_ORE));
            this.displayRecipes.add(new SlimefunItemStack(SlimefunItems.IRON_DUST, this.isOreDoublingEnabled() ? 2 : 1));
            this.displayRecipes.add(new ItemStack(Material.DEEPSLATE_GOLD_ORE));
            this.displayRecipes.add(new SlimefunItemStack(SlimefunItems.GOLD_DUST, this.isOreDoublingEnabled() ? 2 : 1));
            this.displayRecipes.add(new ItemStack(Material.DEEPSLATE_COPPER_ORE));
            this.displayRecipes.add(new SlimefunItemStack(SlimefunItems.COPPER_DUST, this.isOreDoublingEnabled() ? 2 : 1));
            this.displayRecipes.add(new ItemStack(Material.COPPER_ORE));
            this.displayRecipes.add(new SlimefunItemStack(SlimefunItems.COPPER_DUST, this.isOreDoublingEnabled() ? 2 : 1));
        }
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        return this.recipes.stream().map(items -> items[0]).collect(Collectors.toList());
    }

    @Override
    public void onInteract(Player p, Block b) {
        Block possibleDispenser = b.getRelative(BlockFace.DOWN);
        BlockState state = PaperLib.getBlockState(possibleDispenser, false).getState();
        if (state instanceof Dispenser) {
            Dispenser dispenser = (Dispenser)state;
            Inventory inv = dispenser.getInventory();
            for (ItemStack current : inv.getContents()) {
                for (ItemStack convert : RecipeType.getRecipeInputs(this)) {
                    if (convert == null || !SlimefunUtils.isItemSimilar(current, convert, true)) continue;
                    ItemStack adding = RecipeType.getRecipeOutput(this, convert);
                    Inventory outputInv = this.findOutputInventory(adding, possibleDispenser, inv);
                    if (SlimefunUtils.canPlayerUseItem(p, adding, true)) {
                        if (outputInv != null) {
                            ItemStack removing = current.clone();
                            removing.setAmount(convert.getAmount());
                            inv.removeItem(new ItemStack[]{removing});
                            outputInv.addItem(new ItemStack[]{adding});
                            p.getWorld().playEffect(b.getLocation(), Effect.STEP_SOUND, 1);
                        } else {
                            Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.full-inventory", true);
                        }
                    }
                    return;
                }
            }
            Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.unknown-material", true);
        }
    }

    private class DoubleOreSetting
    extends ItemSetting<Boolean> {
        private final ItemStack coal;
        private final ItemStack lapis;
        private final ItemStack redstone;
        private final ItemStack diamond;
        private final ItemStack emerald;
        private final ItemStack quartz;
        private final ItemStack goldNuggets;

        DoubleOreSetting(OreCrusher oreCrusher2) {
            super(oreCrusher2, "double-ores", true);
            this.coal = new ItemStack(Material.COAL, 1);
            this.lapis = new ItemStack(Material.LAPIS_LAZULI, 7);
            this.redstone = new ItemStack(Material.REDSTONE, 4);
            this.diamond = new ItemStack(Material.DIAMOND, 1);
            this.emerald = new ItemStack(Material.EMERALD, 1);
            this.quartz = new ItemStack(Material.QUARTZ, 1);
            this.goldNuggets = new ItemStack(Material.GOLD_NUGGET, 4);
        }

        private void apply(boolean value) {
            SlimefunItem goldDust;
            this.coal.setAmount(value ? 2 : 1);
            this.lapis.setAmount(value ? 14 : 7);
            this.redstone.setAmount(value ? 8 : 4);
            this.diamond.setAmount(value ? 2 : 1);
            this.emerald.setAmount(value ? 2 : 1);
            this.quartz.setAmount(value ? 2 : 1);
            this.goldNuggets.setAmount(value ? 8 : 4);
            SlimefunItem ironDust = SlimefunItem.getById("IRON_DUST");
            if (ironDust != null) {
                ironDust.setRecipeOutput(new SlimefunItemStack(SlimefunItems.IRON_DUST, value ? 2 : 1));
            }
            if ((goldDust = SlimefunItem.getById("GOLD_DUST")) != null) {
                goldDust.setRecipeOutput(new SlimefunItemStack(SlimefunItems.GOLD_DUST, value ? 2 : 1));
            }
        }

        @Override
        public void update(Boolean newValue) {
            super.update(newValue);
            this.apply(newValue);
        }

        @Override
        public void reload() {
            super.reload();
            this.apply((Boolean)this.getValue());
        }

        @Nonnull
        public ItemStack getCoal() {
            return this.coal;
        }

        @Nonnull
        public ItemStack getLapisLazuli() {
            return this.lapis;
        }

        @Nonnull
        public ItemStack getRedstone() {
            return this.redstone;
        }

        @Nonnull
        public ItemStack getDiamond() {
            return this.diamond;
        }

        @Nonnull
        public ItemStack getEmerald() {
            return this.emerald;
        }

        @Nonnull
        public ItemStack getNetherQuartz() {
            return this.quartz;
        }

        @Nonnull
        public ItemStack getGoldNuggets() {
            return this.goldNuggets;
        }
    }
}

