/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.dough.collections;

import java.util.Collection;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;

public final class CopyUtils {
    private CopyUtils() {
    }

    public static <T> void deepCopy(@Nonnull Collection<T> source, @Nonnull UnaryOperator<T> cloningFunction, @Nonnull Collection<T> sink) {
        for (T original : source) {
            Object cloned = cloningFunction.apply(original);
            sink.add(cloned);
        }
    }

    @Nonnull
    public static <T, C extends Collection<T>> C deepCopy(@Nonnull Collection<T> source, @Nonnull UnaryOperator<T> cloningFunction, @Nonnull IntFunction<C> sinkSupplier) {
        Collection sink = (Collection)sinkSupplier.apply(source.size());
        CopyUtils.deepCopy(source, cloningFunction, sink);
        return (C)sink;
    }

    public static <K, V> void deepCopy(@Nonnull Map<K, V> source, @Nonnull UnaryOperator<V> cloningFunction, @Nonnull Map<K, V> sink) {
        for (Map.Entry<K, V> entry : source.entrySet()) {
            V original = entry.getValue();
            Object cloned = cloningFunction.apply(original);
            sink.put(entry.getKey(), cloned);
        }
    }

    @Nonnull
    public static <K, V, M extends Map<K, V>> M deepCopy(@Nonnull Map<K, V> source, @Nonnull UnaryOperator<V> cloningFunction, @Nonnull Supplier<M> sinkSupplier) {
        Map sink = (Map)sinkSupplier.get();
        CopyUtils.deepCopy(source, cloningFunction, sink);
        return (M)sink;
    }

    public static <K, V> void deepCopy(@Nonnull Map<K, V> source, @Nonnull UnaryOperator<V> cloningFunction) {
        for (Map.Entry entry : source.entrySet()) {
            V original = entry.getValue();
            Object cloned = cloningFunction.apply(original);
            entry.setValue(cloned);
        }
    }

    public static <T> void deepCopy(@Nonnull T[] source, @Nonnull UnaryOperator<T> cloningFunction, @Nonnull T[] sink) {
        if (source.length > sink.length) {
            throw new IllegalArgumentException("Length of sink must be greater than or equal to that of the source!");
        }
        for (int i = 0; i < source.length; ++i) {
            sink[i] = cloningFunction.apply(source[i]);
        }
    }

    @Nonnull
    public static <T> T[] deepCopy(@Nonnull T[] source, @Nonnull UnaryOperator<T> cloningFunction, @Nonnull IntFunction<T[]> sinkSupplier) {
        T[] sink = sinkSupplier.apply(source.length);
        CopyUtils.deepCopy(source, cloningFunction, sink);
        return sink;
    }
}

