/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.guide.options;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.core.SlimefunRegistry;
import io.github.thebusybiscuit.slimefun4.core.guide.options.SlimefunGuideOption;
import io.github.thebusybiscuit.slimefun4.core.guide.options.SlimefunGuideSettings;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;

class LearningAnimationOption
implements SlimefunGuideOption<Boolean> {
    LearningAnimationOption() {
    }

    @Override
    @Nonnull
    public SlimefunAddon getAddon() {
        return Slimefun.instance();
    }

    @Nonnull
    public NamespacedKey getKey() {
        return new NamespacedKey((Plugin)Slimefun.instance(), "research_learning_animation");
    }

    @Override
    @Nonnull
    public Optional<ItemStack> getDisplayItem(@Nonnull Player p, @Nonnull ItemStack guide) {
        SlimefunRegistry registry = Slimefun.getRegistry();
        if (!registry.isResearchingEnabled() || registry.isLearningAnimationDisabled()) {
            return Optional.empty();
        }
        boolean enabled = this.getSelectedOption(p, guide).orElse(true);
        String optionState = enabled ? "enabled" : "disabled";
        List<String> lore = Slimefun.getLocalization().getMessages(p, "guide.options.learning-animation." + optionState + ".text");
        lore.add("");
        lore.add("&7\u21e8 " + Slimefun.getLocalization().getMessage(p, "guide.options.learning-animation." + optionState + ".click"));
        CustomItemStack item = new CustomItemStack(enabled ? Material.MAP : Material.PAPER, lore);
        return Optional.of(item);
    }

    @Override
    public void onClick(@Nonnull Player p, @Nonnull ItemStack guide) {
        this.setSelectedOption(p, guide, this.getSelectedOption(p, guide).orElse(true) == false);
        SlimefunGuideSettings.openSettings(p, guide);
    }

    @Override
    public Optional<Boolean> getSelectedOption(@Nonnull Player p, @Nonnull ItemStack guide) {
        NamespacedKey key = this.getKey();
        boolean value = !PersistentDataAPI.hasByte((PersistentDataHolder)p, key) || PersistentDataAPI.getByte((PersistentDataHolder)p, key) == 1;
        return Optional.of(value);
    }

    @Override
    public void setSelectedOption(@Nonnull Player p, @Nonnull ItemStack guide, @Nonnull Boolean value) {
        PersistentDataAPI.setByte((PersistentDataHolder)p, this.getKey(), (byte)(value != false ? 1 : 0));
    }
}

