/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.commands.subcommands;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.core.commands.SlimefunCommand;
import io.github.thebusybiscuit.slimefun4.core.commands.SubCommand;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.plugin.Plugin;

class VersionsCommand
extends SubCommand {
    private static final int RECOMMENDED_JAVA_VERSION = 16;
    private static final String JAVA_VERSION_NOTICE = "As of Minecraft 1.17 Java 16 will be required!";

    @ParametersAreNonnullByDefault
    VersionsCommand(Slimefun plugin, SlimefunCommand cmd) {
        super(plugin, cmd, "versions", false);
    }

    @Override
    public void onExecute(@Nonnull CommandSender sender, @Nonnull String[] args) {
        if (sender.hasPermission("slimefun.command.versions") || sender instanceof ConsoleCommandSender) {
            String serverSoftware = PaperLib.isSpigot() && !PaperLib.isPaper() ? "Spigot" : Bukkit.getName();
            ComponentBuilder builder = new ComponentBuilder();
            builder.append("This Server uses the following setup of Slimefun:\n").color(ChatColor.GRAY).append(serverSoftware).color(ChatColor.GREEN).append(" " + Bukkit.getVersion() + "\n").color(ChatColor.DARK_GREEN).append("Slimefun ").color(ChatColor.GREEN).append(Slimefun.getVersion() + "\n").color(ChatColor.DARK_GREEN);
            if (Slimefun.getMetricsService().getVersion() != null) {
                builder.append("Metrics-Module ").color(ChatColor.GREEN).append("#" + Slimefun.getMetricsService().getVersion() + "\n").color(ChatColor.DARK_GREEN);
            }
            this.addJavaVersion(builder);
            if (Slimefun.getRegistry().isBackwardsCompatible()) {
                HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("Backwards compatibility has a negative impact on performance!\nWe recommend you to disable this setting unless your server still has legacy Slimefun items (from before summer 2019) in circulation.")});
                builder.append("\nBackwards compatibility enabled!\n").color(ChatColor.RED).event(hoverEvent);
            }
            builder.append("\n").event((HoverEvent)null);
            this.addPluginVersions(builder);
            sender.spigot().sendMessage(builder.create());
        } else {
            Slimefun.getLocalization().sendMessage(sender, "messages.no-permission", true);
        }
    }

    private void addJavaVersion(@Nonnull ComponentBuilder builder) {
        int version = NumberUtils.getJavaVersion();
        if (version < 16) {
            builder.append("Java " + version).color(ChatColor.RED).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("Your Java version is out of date!\n!You should use Java 16 or higher.\nAs of Minecraft 1.17 Java 16 will be required!")})).append("\n").event((HoverEvent)null);
        } else {
            builder.append("Java ").color(ChatColor.GREEN).append(version + "\n").color(ChatColor.DARK_GREEN);
        }
    }

    private void addPluginVersions(@Nonnull ComponentBuilder builder) {
        Set<Plugin> addons = Slimefun.getInstalledAddons();
        if (addons.isEmpty()) {
            builder.append("No Addons installed").color(ChatColor.GRAY).italic(true);
            return;
        }
        builder.append("Installed Addons: ").color(ChatColor.GRAY).append("(" + addons.size() + ")").color(ChatColor.DARK_GRAY);
        for (Plugin plugin : addons) {
            ChatColor secondaryColor;
            ChatColor primaryColor;
            String version = plugin.getDescription().getVersion();
            HoverEvent hoverEvent = null;
            ClickEvent clickEvent = null;
            if (Bukkit.getPluginManager().isPluginEnabled(plugin)) {
                SlimefunAddon addon;
                primaryColor = ChatColor.GREEN;
                secondaryColor = ChatColor.DARK_GREEN;
                String authors = String.join((CharSequence)", ", plugin.getDescription().getAuthors());
                if (plugin instanceof SlimefunAddon && (addon = (SlimefunAddon)plugin).getBugTrackerURL() != null) {
                    hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(new ComponentBuilder().append("Author(s): ").append(authors).color(ChatColor.YELLOW).append("\n> Click here to go to their issues tracker").color(ChatColor.GOLD).create())});
                    clickEvent = new ClickEvent(ClickEvent.Action.OPEN_URL, addon.getBugTrackerURL());
                } else {
                    hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(new ComponentBuilder().append("Author(s): ").append(authors).color(ChatColor.YELLOW).create())});
                }
            } else {
                SlimefunAddon addon;
                primaryColor = ChatColor.RED;
                secondaryColor = ChatColor.DARK_RED;
                if (plugin instanceof SlimefunAddon && (addon = (SlimefunAddon)plugin).getBugTrackerURL() != null) {
                    hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(new ComponentBuilder().append("This plugin is disabled.\nCheck the console for an error message.").color(ChatColor.RED).append("\n> Click here to report on their issues tracker").color(ChatColor.DARK_RED).create())});
                    if (addon.getBugTrackerURL() != null) {
                        clickEvent = new ClickEvent(ClickEvent.Action.OPEN_URL, addon.getBugTrackerURL());
                    }
                } else {
                    hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("Plugin is disabled. Check the console for an error and report on their issues tracker.")});
                }
            }
            builder.append("\n  " + plugin.getName()).color(primaryColor).event(hoverEvent).event(clickEvent).append(" v" + version).color(secondaryColor).append("").event((ClickEvent)null).event((HoverEvent)null);
        }
    }
}

