/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.items.settings;

import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

public class DoubleRangeSetting
extends ItemSetting<Double> {
    private final double min;
    private final double max;

    @ParametersAreNonnullByDefault
    public DoubleRangeSetting(SlimefunItem item, String key, double min, double defaultValue, double max) {
        super(item, key, defaultValue);
        Validate.isTrue(defaultValue >= min && defaultValue <= max, "The default value is not in range.");
        this.min = min;
        this.max = max;
    }

    @Override
    @Nonnull
    protected String getErrorMessage() {
        return "Only decimal numbers from " + this.min + "-" + this.max + "(inclusive) are allowed!";
    }

    @Override
    public boolean validateInput(Double input) {
        return super.validateInput(input) && input >= this.min && input <= this.max;
    }

    public final double getMinimum() {
        return this.min;
    }

    public final double getMaximum() {
        return this.max;
    }
}

