/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import java.util.Optional;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class BlockDataService
implements Keyed {
    private final NamespacedKey namespacedKey;

    public BlockDataService(@Nonnull Plugin plugin, @Nonnull String key) {
        this.namespacedKey = new NamespacedKey(plugin, key);
    }

    public NamespacedKey getKey() {
        return this.namespacedKey;
    }

    public void setBlockData(@Nonnull Block b, @Nonnull String value) {
        Validate.notNull(b, "The block cannot be null!");
        Validate.notNull(value, "The value cannot be null!");
        BlockState state = b.getState();
        if (state instanceof TileState) {
            TileState tileState = (TileState)state;
            try {
                PersistentDataContainer container = tileState.getPersistentDataContainer();
                container.set(this.namespacedKey, PersistentDataType.STRING, (Object)value);
                state.update();
            }
            catch (Exception x) {
                Slimefun.logger().log(Level.SEVERE, "Please check if your Server Software is up to date!");
                String serverSoftware = PaperLib.isSpigot() && !PaperLib.isPaper() ? "Spigot" : Bukkit.getName();
                Slimefun.logger().log(Level.SEVERE, () -> serverSoftware + " | " + Bukkit.getVersion() + " | " + Bukkit.getBukkitVersion());
                Slimefun.logger().log(Level.SEVERE, "An Exception was thrown while trying to set Persistent Data for a Block", x);
            }
        }
    }

    public Optional<String> getBlockData(@Nonnull Block b) {
        Validate.notNull(b, "The block cannot be null!");
        BlockState state = PaperLib.getBlockState(b, false).getState();
        PersistentDataContainer container = this.getPersistentDataContainer(state);
        if (container != null) {
            return Optional.ofNullable((String)container.get(this.namespacedKey, PersistentDataType.STRING));
        }
        return Optional.empty();
    }

    @Nullable
    private PersistentDataContainer getPersistentDataContainer(@Nonnull BlockState state) {
        if (state instanceof TileState) {
            TileState tileState = (TileState)state;
            return tileState.getPersistentDataContainer();
        }
        return null;
    }

    public boolean isTileEntity(@Nullable Material type) {
        if (type == null || type.isAir()) {
            return false;
        }
        return switch (type) {
            case Material.PLAYER_HEAD, Material.PLAYER_WALL_HEAD, Material.CHEST, Material.DISPENSER, Material.BREWING_STAND, Material.DROPPER, Material.FURNACE, Material.BLAST_FURNACE, Material.HOPPER, Material.LECTERN, Material.JUKEBOX, Material.ENDER_CHEST, Material.ENCHANTING_TABLE, Material.DAYLIGHT_DETECTOR, Material.SMOKER, Material.BARREL, Material.SPAWNER, Material.BEACON -> true;
            default -> false;
        };
    }
}

