/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.magical.talismans;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.api.researches.Research;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.magical.talismans.EnderTalisman;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;

public class Talisman
extends SlimefunItem {
    protected static final ItemGroup TALISMANS_ITEMGROUP = new ItemGroup(new NamespacedKey((Plugin)Slimefun.instance(), "talismans"), new CustomItemStack((ItemStack)SlimefunItems.COMMON_TALISMAN, "&7Talismans - &aTier I", new String[0]), 2);
    private static final String WIKI_PAGE = "Talismans";
    private final SlimefunItemStack enderTalisman;
    protected final String suffix;
    protected final boolean consumable;
    protected final boolean cancel;
    protected final PotionEffect[] effects;
    protected final int chance;

    @ParametersAreNonnullByDefault
    public Talisman(SlimefunItemStack item, ItemStack[] recipe, boolean consumable, boolean cancelEvent, @Nullable String messageSuffix, PotionEffect ... effects) {
        this(item, recipe, consumable, cancelEvent, messageSuffix, 100, effects);
    }

    @ParametersAreNonnullByDefault
    public Talisman(SlimefunItemStack item, ItemStack[] recipe, @Nullable String messageSuffix, int chance, PotionEffect ... effects) {
        this(item, recipe, true, true, messageSuffix, chance, effects);
    }

    @ParametersAreNonnullByDefault
    public Talisman(SlimefunItemStack item, ItemStack[] recipe, boolean consumable, boolean cancelEvent, @Nullable String messageSuffix, int chance, PotionEffect ... effects) {
        this(TALISMANS_ITEMGROUP, item, recipe, consumable, cancelEvent, messageSuffix, chance, effects);
    }

    @ParametersAreNonnullByDefault
    protected Talisman(ItemGroup itemGroup, SlimefunItemStack item, ItemStack[] recipe, boolean consumable, boolean cancelEvent, @Nullable String messageSuffix, int chance, PotionEffect ... effects) {
        super(itemGroup, item, RecipeType.MAGIC_WORKBENCH, recipe, new CustomItemStack((ItemStack)item, consumable ? 4 : 1));
        this.consumable = consumable;
        this.cancel = cancelEvent;
        this.suffix = messageSuffix;
        this.effects = effects;
        this.chance = chance;
        this.addOfficialWikipage(WIKI_PAGE);
        if (!(this instanceof EnderTalisman)) {
            String name = "&5Ender " + ChatColor.stripColor((String)this.getItem().getItemMeta().getDisplayName());
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("&7&oEnder Infused");
            lore.add("");
            for (String line : this.getItem().getItemMeta().getLore()) {
                lore.add(line);
            }
            this.enderTalisman = new SlimefunItemStack("ENDER_" + this.getId(), this.getItem().getType(), name, lore.toArray(new String[0]));
        } else {
            this.enderTalisman = null;
        }
    }

    public boolean isConsumable() {
        return this.consumable;
    }

    public int getChance() {
        return this.chance;
    }

    @Nonnull
    public PotionEffect[] getEffects() {
        return this.effects;
    }

    protected boolean isEventCancelled() {
        return this.cancel;
    }

    @Nullable
    private SlimefunItemStack getEnderVariant() {
        return this.enderTalisman;
    }

    @Override
    public void postRegister() {
        EnderTalisman talisman = new EnderTalisman(this, this.getEnderVariant());
        talisman.register(this.getAddon());
    }

    @Override
    public void load() {
        super.load();
        this.loadEnderTalisman();
    }

    void loadEnderTalisman() {
        EnderTalisman talisman = (EnderTalisman)SlimefunItem.getByItem(this.getEnderVariant());
        Optional<Research> research = Research.getResearch(new NamespacedKey((Plugin)Slimefun.instance(), "ender_talismans"));
        if (talisman != null && research.isPresent()) {
            talisman.setResearch(research.get());
        }
    }

    @ParametersAreNonnullByDefault
    public static boolean trigger(Event e, SlimefunItemStack stack) {
        return Talisman.trigger(e, stack.getItem(), true);
    }

    @ParametersAreNonnullByDefault
    public static boolean trigger(Event e, SlimefunItemStack stack, boolean sendMessage) {
        return Talisman.trigger(e, stack.getItem(), sendMessage);
    }

    @ParametersAreNonnullByDefault
    public static boolean trigger(Event e, SlimefunItem item) {
        return Talisman.trigger(e, item, true);
    }

    @ParametersAreNonnullByDefault
    public static boolean trigger(Event e, SlimefunItem item, boolean sendMessage) {
        if (!(item instanceof Talisman)) {
            return false;
        }
        Talisman talisman = (Talisman)item;
        if (ThreadLocalRandom.current().nextInt(100) > talisman.getChance()) {
            return false;
        }
        Player p = Talisman.getPlayerByEventType(e);
        if (p == null || !talisman.canEffectsBeApplied(p)) {
            return false;
        }
        ItemStack talismanItem = talisman.getItem();
        if (SlimefunUtils.containsSimilarItem((Inventory)p.getInventory(), talismanItem, true)) {
            if (talisman.canUse(p, true)) {
                Talisman.activateTalisman(e, p, (Inventory)p.getInventory(), talisman, talismanItem, sendMessage);
                return true;
            }
            return false;
        }
        SlimefunItemStack enderTalisman = talisman.getEnderVariant();
        if (SlimefunUtils.containsSimilarItem(p.getEnderChest(), enderTalisman, true)) {
            if (talisman.canUse(p, true)) {
                Talisman.activateTalisman(e, p, p.getEnderChest(), talisman, enderTalisman, sendMessage);
                return true;
            }
            return false;
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    private static void activateTalisman(Event e, Player p, Inventory inv, Talisman talisman, ItemStack talismanItem, boolean sendMessage) {
        Talisman.consumeItem(inv, talisman, talismanItem);
        Talisman.applyTalismanEffects(p, talisman);
        Talisman.cancelEvent(e, talisman);
        if (sendMessage) {
            talisman.sendMessage(p);
        }
    }

    @ParametersAreNonnullByDefault
    private static void consumeItem(Inventory inv, Talisman talisman, ItemStack talismanItem) {
        if (talisman.isConsumable()) {
            ItemStack[] contents = inv.getContents();
            for (int i = 0; i < contents.length; ++i) {
                ItemStack item = contents[i];
                if (!SlimefunUtils.isItemSimilar(item, talismanItem, true, false)) continue;
                ItemUtils.consumeItem(item, false);
                return;
            }
        }
    }

    @ParametersAreNonnullByDefault
    private static void applyTalismanEffects(Player p, Talisman talisman) {
        for (PotionEffect effect : talisman.getEffects()) {
            p.addPotionEffect(effect);
        }
    }

    @ParametersAreNonnullByDefault
    private static void cancelEvent(Event e, Talisman talisman) {
        if (e instanceof Cancellable) {
            Cancellable cancellable = (Cancellable)e;
            if (talisman.isEventCancelled()) {
                cancellable.setCancelled(true);
            }
        }
    }

    public boolean isSilent() {
        return this.getMessageSuffix() == null;
    }

    @Nullable
    protected final String getMessageSuffix() {
        return this.suffix;
    }

    public void sendMessage(@Nonnull Player p) {
        Validate.notNull(p, "The Player must not be null.");
        if (!this.isSilent()) {
            try {
                String messageKey = "messages.talisman." + this.getMessageSuffix();
                if (Slimefun.getRegistry().useActionbarForTalismans()) {
                    Slimefun.getLocalization().sendActionbarMessage(p, messageKey, false);
                } else {
                    Slimefun.getLocalization().sendMessage((CommandSender)p, messageKey, true);
                }
            }
            catch (Exception x) {
                this.error("An Exception was thrown while trying to send a Talisman message", x);
            }
        }
    }

    private boolean canEffectsBeApplied(@Nonnull Player p) {
        for (PotionEffect effect : this.getEffects()) {
            if (effect == null || !p.hasPotionEffect(effect.getType())) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static Player getPlayerByEventType(@Nonnull Event e) {
        if (e instanceof EntityDeathEvent) {
            EntityDeathEvent entityDeathEvent = (EntityDeathEvent)e;
            return entityDeathEvent.getEntity().getKiller();
        }
        if (e instanceof BlockBreakEvent) {
            BlockBreakEvent blockBreakEvent = (BlockBreakEvent)e;
            return blockBreakEvent.getPlayer();
        }
        if (e instanceof BlockDropItemEvent) {
            BlockDropItemEvent blockDropItemEvent = (BlockDropItemEvent)e;
            return blockDropItemEvent.getPlayer();
        }
        if (e instanceof PlayerEvent) {
            PlayerEvent playerEvent = (PlayerEvent)e;
            return playerEvent.getPlayer();
        }
        if (e instanceof EntityEvent) {
            EntityEvent entityEvent = (EntityEvent)e;
            return (Player)entityEvent.getEntity();
        }
        if (e instanceof EnchantItemEvent) {
            EnchantItemEvent enchantItemEvent = (EnchantItemEvent)e;
            return enchantItemEvent.getEnchanter();
        }
        return null;
    }
}

