/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.blocks.OutputChest;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Effect;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class TableSaw
extends MultiBlockMachine {
    private final List<ItemStack> displayedRecipes = new ArrayList<ItemStack>();

    @ParametersAreNonnullByDefault
    public TableSaw(ItemGroup group, SlimefunItemStack item) {
        super(group, item, new ItemStack[]{null, null, null, new ItemStack(Material.SMOOTH_STONE_SLAB), new ItemStack(Material.STONECUTTER), new ItemStack(Material.SMOOTH_STONE_SLAB), null, new ItemStack(Material.IRON_BLOCK), null}, BlockFace.SELF);
        for (Material log : Tag.LOGS.getValues()) {
            Optional<Material> planks = this.getPlanks(log);
            if (!planks.isPresent()) continue;
            this.displayedRecipes.add(new ItemStack(log));
            this.displayedRecipes.add(new ItemStack(planks.get(), 8));
        }
        for (Material plank : Tag.PLANKS.getValues()) {
            this.displayedRecipes.add(new ItemStack(plank));
            this.displayedRecipes.add(new ItemStack(Material.STICK, 4));
        }
    }

    @Nonnull
    private Optional<Material> getPlanks(@Nonnull Material log) {
        Object materialName = log.name().replace("STRIPPED_", "");
        materialName = ((String)materialName).substring(0, ((String)materialName).lastIndexOf(95)) + "_PLANKS";
        return Optional.ofNullable(Material.getMaterial((String)materialName));
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        return this.displayedRecipes;
    }

    @Override
    public void onInteract(@Nonnull Player p, @Nonnull Block b) {
        ItemStack item = p.getInventory().getItemInMainHand();
        ItemStack output = this.getOutputFromMaterial(item.getType());
        if (output == null) {
            Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.wrong-item", true);
            return;
        }
        if (p.getGameMode() != GameMode.CREATIVE) {
            ItemUtils.consumeItem(item, true);
        }
        this.outputItems(b, output);
        b.getWorld().playEffect(b.getLocation(), Effect.STEP_SOUND, (Object)item.getType());
    }

    @Nullable
    private ItemStack getOutputFromMaterial(@Nonnull Material item) {
        if (Tag.LOGS.isTagged((Keyed)item)) {
            Optional<Material> planks = this.getPlanks(item);
            if (planks.isPresent()) {
                return new ItemStack(planks.get(), 8);
            }
            return null;
        }
        if (Tag.PLANKS.isTagged((Keyed)item)) {
            return new ItemStack(Material.STICK, 4);
        }
        return null;
    }

    private void outputItems(@Nonnull Block b, @Nonnull ItemStack output) {
        Optional<Inventory> outputChest = OutputChest.findOutputChestFor(b, output);
        if (outputChest.isPresent()) {
            outputChest.get().addItem(new ItemStack[]{output});
        } else {
            b.getWorld().dropItemNaturally(b.getLocation(), output);
        }
    }
}

