/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.handlers;

import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class VanillaInventoryDropHandler<T extends BlockState & InventoryHolder>
extends BlockBreakHandler {
    private final Class<T> blockStateClass;

    public VanillaInventoryDropHandler(@Nonnull Class<T> blockStateClass) {
        super(false, true);
        Validate.notNull(blockStateClass, "The provided class must not be null!");
        this.blockStateClass = blockStateClass;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onPlayerBreak(BlockBreakEvent e, ItemStack item, List<ItemStack> drops) {
        if (!PaperLib.isPaper()) {
            return;
        }
        Block b = e.getBlock();
        BlockState state = PaperLib.getBlockState(b, false).getState();
        if (this.blockStateClass.isInstance(state)) {
            BlockState inventoryHolder = (BlockState)this.blockStateClass.cast(state);
            for (ItemStack stack : this.getInventory(inventoryHolder)) {
                if (stack == null || stack.getType().isAir()) continue;
                drops.add(stack);
            }
        }
    }

    @Nonnull
    protected Inventory getInventory(@Nonnull T inventoryHolder) {
        if (inventoryHolder instanceof Chest) {
            return ((Chest)inventoryHolder).getBlockInventory();
        }
        return ((InventoryHolder)inventoryHolder).getInventory();
    }
}

