/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.dough.updater;

import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.PluginUpdater;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.UpdaterTask;
import io.github.thebusybiscuit.slimefun4.libraries.dough.versions.Version;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

abstract class AbstractPluginUpdater<V extends Version>
implements PluginUpdater<V> {
    private final Plugin plugin;
    private final File file;
    private int connectionTimeout = 9000;
    protected final V currentVersion;
    protected final CompletableFuture<V> latestVersion = new CompletableFuture();

    @ParametersAreNonnullByDefault
    protected AbstractPluginUpdater(Plugin plugin, File file, V currentVersion) {
        Validate.notNull(plugin, "The plugin cannot be null.");
        Validate.notNull(file, "The plugin file cannot be null.");
        Validate.notNull(currentVersion, "The current version cannot be null.");
        this.plugin = plugin;
        this.file = file;
        this.currentVersion = currentVersion;
        this.prepareUpdateFolder();
    }

    private void prepareUpdateFolder() {
        File dir = new File("plugins/" + Bukkit.getUpdateFolder());
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int timeout) {
        Validate.isTrue(timeout > 0, "Timeout must be positive.");
        this.connectionTimeout = timeout;
    }

    @Override
    @Nonnull
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Nonnull
    public Logger getLogger() {
        return this.plugin.getLogger();
    }

    @Override
    @Nonnull
    public File getFile() {
        return this.file;
    }

    @Override
    @Nonnull
    public V getCurrentVersion() {
        return this.currentVersion;
    }

    @Override
    @Nonnull
    public CompletableFuture<V> getLatestVersion() {
        return this.latestVersion;
    }

    protected void scheduleAsyncUpdateTask(@Nonnull UpdaterTask<V> task) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously(this.plugin, task);
    }
}

