/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.autocrafters;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.items.autocrafters.SlimefunItemRecipe;
import io.github.thebusybiscuit.slimefun4.implementation.items.autocrafters.VanillaRecipe;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.AsyncRecipeChoiceTask;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import java.util.Collection;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public abstract class AbstractRecipe {
    private final Collection<Predicate<ItemStack>> ingredients;
    private final ItemStack result;
    private boolean enabled = true;

    @ParametersAreNonnullByDefault
    protected AbstractRecipe(Collection<Predicate<ItemStack>> ingredients, ItemStack result) {
        Validate.notEmpty(ingredients, "The input predicates cannot be null or an empty array");
        Validate.notNull(result, "The recipe result must not be null!");
        this.ingredients = ingredients;
        this.result = result;
    }

    @Nonnull
    public Collection<Predicate<ItemStack>> getIngredients() {
        return this.ingredients;
    }

    @Nonnull
    public ItemStack getResult() {
        return this.result;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public abstract void show(@Nonnull ChestMenu var1, @Nonnull AsyncRecipeChoiceTask var2);

    @Nullable
    public static AbstractRecipe of(@Nullable Recipe recipe) {
        if (recipe instanceof ShapedRecipe) {
            return new VanillaRecipe((ShapedRecipe)recipe);
        }
        if (recipe instanceof ShapelessRecipe) {
            return new VanillaRecipe((ShapelessRecipe)recipe);
        }
        return null;
    }

    @Nullable
    public static AbstractRecipe of(@Nullable SlimefunItem item, @Nonnull RecipeType recipeType) {
        if (item != null && item.getRecipeType().equals(recipeType)) {
            return new SlimefunItemRecipe(item);
        }
        return null;
    }
}

