/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.tasks;

import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.AbstractPlayerTask;
import javax.annotation.Nonnull;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class BeeWingsTask
extends AbstractPlayerTask {
    private static final int MIN_ALTITUDE = 4;
    private Location lastLocation;

    public BeeWingsTask(@Nonnull Player p) {
        super(p);
        this.lastLocation = p.getLocation();
    }

    @Override
    protected void executeTask() {
        if (this.p.getLocation().getY() < this.lastLocation.getY()) {
            Location loc = this.p.getLocation();
            int distanceToHighestBlock = loc.getBlockY() - loc.getWorld().getHighestBlockYAt(loc, HeightMap.WORLD_SURFACE);
            if (distanceToHighestBlock < 0) {
                int distanceToGround = this.getDistanceToGround(loc.getBlock(), 6);
                if (distanceToGround < 1) {
                    return;
                }
                this.slowDown();
            } else if (distanceToHighestBlock <= 4) {
                this.slowDown();
            }
        }
        this.lastLocation = this.p.getLocation();
    }

    private void slowDown() {
        Slimefun.getLocalization().sendMessage((CommandSender)this.p, "messages.bee-suit-slow-fall");
        this.p.setFallDistance(0.0f);
        this.p.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_FALLING, 60, 0));
    }

    private int getDistanceToGround(@Nonnull Block b, int limit) {
        for (int i = 1; i <= limit; ++i) {
            Block relative = b.getRelative(0, -i, 0);
            if (!relative.getType().isSolid()) continue;
            return i;
        }
        return 0;
    }

    @Override
    protected boolean isValid() {
        if (!this.p.isOnline() || !this.p.isValid() || this.p.isDead() || !this.p.isGliding() || this.p.hasPotionEffect(PotionEffectType.SLOW_FALLING)) {
            this.cancel();
            return false;
        }
        return true;
    }
}

