/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.minecraft.helper;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import net.guizhanss.guizhanlib.minecraft.LanguageHelper;
import net.guizhanss.guizhanlib.utils.StringUtil;
import org.bukkit.Material;

public final class MaterialHelper {
    @Nonnull
    public static String getName(@Nonnull Material mat) {
        return LanguageHelper.getLangOrKey(MaterialHelper.getKey(mat));
    }

    @Nonnull
    public static String getKey(@Nonnull Material mat) {
        Preconditions.checkArgument((mat != null ? 1 : 0) != 0, (Object)"\u6750\u6599\u4e0d\u80fd\u4e3a\u7a7a");
        return (mat.isBlock() ? "block" : "item") + "." + mat.getKey().getNamespace() + "." + mat.getKey().getKey();
    }

    @Nonnull
    public static String getName(@Nonnull String material) {
        return MaterialHelper.getName(material, false);
    }

    @Nonnull
    public static String getName(@Nonnull String material, boolean emptyString) {
        Material mat = Material.getMaterial((String)material);
        if (mat == null) {
            return emptyString ? "" : StringUtil.humanize(material);
        }
        return MaterialHelper.getName(mat);
    }

    private MaterialHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

