/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.minecraft.utils.compatibility;

import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.guizhanss.guizhanlib.minecraft.utils.MinecraftVersionUtil;
import org.bukkit.Particle;

public final class ParticleX {
    public static final Particle POOF;
    public static final Particle EXPLOSION;
    public static final Particle EXPLOSION_EMITTER;
    public static final Particle FIREWORK;
    public static final Particle BUBBLE;
    public static final Particle SPLASH;
    public static final Particle FISHING;
    public static final Particle UNDERWATER;
    public static final Particle ENCHANTED_HIT;
    public static final Particle SMOKE;
    public static final Particle LARGE_SMOKE;
    public static final Particle EFFECT;
    public static final Particle INSTANT_EFFECT;
    public static final Particle ENTITY_EFFECT;
    public static final Particle WITCH;
    public static final Particle DRIPPING_WATER;
    public static final Particle DRIPPING_LAVA;
    public static final Particle ANGRY_VILLAGER;
    public static final Particle HAPPY_VILLAGER;
    public static final Particle MYCELIUM;
    public static final Particle ENCHANT;
    public static final Particle DUST;
    public static final Particle ITEM_SNOWBALL;
    public static final Particle ITEM_SLIME;
    public static final Particle ITEM;
    public static final Particle BLOCK;
    public static final Particle RAIN;
    public static final Particle ELDER_GUARDIAN;
    public static final Particle TOTEM_OF_UNDYING;
    public static final Particle GUST_EMITTER_LARGE;

    @Nullable
    private static Particle getField(@Nonnull String key) {
        try {
            Field field = Particle.class.getDeclaredField(key);
            return (Particle)field.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    private ParticleX() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        boolean isAtLeast1_20_5 = MinecraftVersionUtil.isAtLeast(20, 5);
        POOF = isAtLeast1_20_5 ? Particle.POOF : ParticleX.getField("EXPLOSION_NORMAL");
        EXPLOSION = isAtLeast1_20_5 ? Particle.EXPLOSION : ParticleX.getField("EXPLOSION_LARGE");
        EXPLOSION_EMITTER = isAtLeast1_20_5 ? Particle.EXPLOSION_EMITTER : ParticleX.getField("EXPLOSION_HUGE");
        FIREWORK = isAtLeast1_20_5 ? Particle.FIREWORK : ParticleX.getField("FIREWORKS_SPARK");
        BUBBLE = isAtLeast1_20_5 ? Particle.BUBBLE : ParticleX.getField("WATER_BUBBLE");
        SPLASH = isAtLeast1_20_5 ? Particle.SPLASH : ParticleX.getField("WATER_SPLASH");
        FISHING = isAtLeast1_20_5 ? Particle.FISHING : ParticleX.getField("WATER_WAKE");
        UNDERWATER = isAtLeast1_20_5 ? Particle.UNDERWATER : ParticleX.getField("SUSPENDED");
        ENCHANTED_HIT = isAtLeast1_20_5 ? Particle.ENCHANTED_HIT : ParticleX.getField("CRIT_MAGIC");
        SMOKE = isAtLeast1_20_5 ? Particle.SMOKE : ParticleX.getField("SMOKE_NORMAL");
        LARGE_SMOKE = isAtLeast1_20_5 ? Particle.LARGE_SMOKE : ParticleX.getField("SMOKE_LARGE");
        EFFECT = isAtLeast1_20_5 ? Particle.EFFECT : ParticleX.getField("SPELL");
        INSTANT_EFFECT = isAtLeast1_20_5 ? Particle.INSTANT_EFFECT : ParticleX.getField("SPELL_INSTANT");
        ENTITY_EFFECT = isAtLeast1_20_5 ? Particle.ENTITY_EFFECT : ParticleX.getField("SPELL_MOB");
        WITCH = isAtLeast1_20_5 ? Particle.WITCH : ParticleX.getField("SPELL_WITCH");
        DRIPPING_WATER = isAtLeast1_20_5 ? Particle.DRIPPING_WATER : ParticleX.getField("DRIP_WATER");
        DRIPPING_LAVA = isAtLeast1_20_5 ? Particle.DRIPPING_LAVA : ParticleX.getField("DRIP_LAVA");
        ANGRY_VILLAGER = isAtLeast1_20_5 ? Particle.ANGRY_VILLAGER : ParticleX.getField("VILLAGER_ANGRY");
        HAPPY_VILLAGER = isAtLeast1_20_5 ? Particle.HAPPY_VILLAGER : ParticleX.getField("VILLAGER_HAPPY");
        MYCELIUM = isAtLeast1_20_5 ? Particle.MYCELIUM : ParticleX.getField("TOWN_AURA");
        ENCHANT = isAtLeast1_20_5 ? Particle.ENCHANT : ParticleX.getField("ENCHANTMENT_TABLE");
        DUST = isAtLeast1_20_5 ? Particle.DUST : ParticleX.getField("REDSTONE");
        ITEM_SNOWBALL = isAtLeast1_20_5 ? Particle.ITEM_SNOWBALL : ParticleX.getField("SNOWBALL");
        ITEM_SLIME = isAtLeast1_20_5 ? Particle.ITEM_SLIME : ParticleX.getField("SLIME");
        ITEM = isAtLeast1_20_5 ? Particle.ITEM : ParticleX.getField("ITEM_CRACK");
        BLOCK = isAtLeast1_20_5 ? Particle.BLOCK : ParticleX.getField("BLOCK_DUST");
        RAIN = isAtLeast1_20_5 ? Particle.RAIN : ParticleX.getField("WATER_DROP");
        ELDER_GUARDIAN = isAtLeast1_20_5 ? Particle.ELDER_GUARDIAN : ParticleX.getField("MOB_APPEARANCE");
        Particle particle = TOTEM_OF_UNDYING = isAtLeast1_20_5 ? Particle.TOTEM_OF_UNDYING : ParticleX.getField("TOTEM");
        GUST_EMITTER_LARGE = MinecraftVersionUtil.isBefore(20) ? null : (isAtLeast1_20_5 ? Particle.GUST_EMITTER_LARGE : ParticleX.getField("GUST_EMITTER"));
    }
}

