/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.minecraft.helper.entity;

import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.guizhanlib.utils.StringUtil;
import org.bukkit.entity.Cat;

public final class CatHelper {
    @Nonnull
    public static String getType(@Nonnull Cat.Type type) {
        return Type.fromType(type).getChinese();
    }

    @Nonnull
    public static String getType(@Nonnull String type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"\u732b\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            Cat.Type catType = Cat.Type.valueOf((String)type);
            return Type.fromType(catType).getChinese();
        }
        catch (IllegalArgumentException ex) {
            return StringUtil.humanize(type);
        }
    }

    private CatHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum Type {
        ALL_BLACK(Cat.Type.ALL_BLACK, "\u9ed1\u732b"),
        BLACK(Cat.Type.BLACK, "\u897f\u670d\u732b"),
        BRITISH_SHORTHAIR(Cat.Type.BRITISH_SHORTHAIR, "\u82f1\u56fd\u77ed\u6bdb\u732b"),
        CALICO(Cat.Type.CALICO, "\u82b1\u732b"),
        JELLIE(Cat.Type.JELLIE, "Jellie"),
        PERSIAN(Cat.Type.PERSIAN, "\u6ce2\u65af\u732b"),
        RAGDOLL(Cat.Type.RAGDOLL, "\u5e03\u5076\u732b"),
        RED(Cat.Type.RED, "\u7ea2\u864e\u6591\u732b"),
        SIAMESE(Cat.Type.SIAMESE, "\u66b9\u7f57\u732b"),
        TABBY(Cat.Type.TABBY, "\u864e\u6591\u732b"),
        WHITE(Cat.Type.WHITE, "\u767d\u732b");

        private static final Type[] cachedValues;
        private static final Map<Cat.Type, Type> typeLookup;
        private final Cat.Type catType;
        private final String chinese;

        @ParametersAreNonnullByDefault
        private Type(Cat.Type type, String chinese) {
            this.catType = type;
            this.chinese = chinese;
        }

        @Nonnull
        public static Type fromType(@Nonnull Cat.Type catType) {
            Preconditions.checkArgument((catType != null ? 1 : 0) != 0, (Object)"\u732b\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            return typeLookup.get(catType);
        }

        @Nonnull
        public String toString() {
            return this.getChinese();
        }

        public Cat.Type getCatType() {
            return this.catType;
        }

        public String getChinese() {
            return this.chinese;
        }

        static {
            cachedValues = Type.values();
            typeLookup = new EnumMap<Cat.Type, Type>(Cat.Type.class);
            for (Type type : cachedValues) {
                typeLookup.put(type.getCatType(), type);
            }
        }
    }
}

