/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.minecraft.helper.entity;

import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.guizhanlib.utils.StringUtil;
import org.bukkit.entity.Horse;

public final class HorseHelper {
    @Nonnull
    public static String getColor(@Nonnull Horse.Color color) {
        return Color.fromColor(color).getChinese();
    }

    @Nonnull
    public static String getStyle(@Nonnull Horse.Style style) {
        return Style.fromStyle(style).getChinese();
    }

    @Nonnull
    public static String getColor(@Nonnull String color) {
        Preconditions.checkArgument((color != null ? 1 : 0) != 0, (Object)"\u9a6c\u7684\u989c\u8272\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            Horse.Color horseColor = Horse.Color.valueOf((String)color);
            return Color.fromColor(horseColor).getChinese();
        }
        catch (IllegalArgumentException ex) {
            return StringUtil.humanize(color);
        }
    }

    @Nonnull
    public static String getStyle(@Nonnull String style) {
        Preconditions.checkArgument((style != null ? 1 : 0) != 0, (Object)"\u9a6c\u7684\u6837\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            Horse.Style horseColor = Horse.Style.valueOf((String)style);
            return Style.fromStyle(horseColor).getChinese();
        }
        catch (IllegalArgumentException ex) {
            return StringUtil.humanize(style);
        }
    }

    private HorseHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum Color {
        BLACK(Horse.Color.BLACK, "\u9ed1\u8272"),
        BROWN(Horse.Color.BROWN, "\u8910\u8272"),
        CHESTNUT(Horse.Color.CHESTNUT, "\u6817\u8272"),
        CREAMY(Horse.Color.CREAMY, "\u5976\u6cb9\u8272"),
        DARK_BROWN(Horse.Color.DARK_BROWN, "\u6df1\u8910\u8272"),
        GRAY(Horse.Color.GRAY, "\u7070\u8272"),
        WHITE(Horse.Color.WHITE, "\u767d\u8272");

        private static final Color[] cachedValues;
        private static final Map<Horse.Color, Color> colorLookup;
        private final Horse.Color horseColor;
        private final String chinese;

        @ParametersAreNonnullByDefault
        private Color(Horse.Color color, String chinese) {
            this.horseColor = color;
            this.chinese = chinese;
        }

        @Nonnull
        public static Color fromColor(@Nonnull Horse.Color horseColor) {
            Preconditions.checkArgument((horseColor != null ? 1 : 0) != 0, (Object)"\u9a6c\u7684\u989c\u8272\u4e0d\u80fd\u4e3a\u7a7a");
            return colorLookup.get(horseColor);
        }

        @Nonnull
        public String toString() {
            return this.getChinese();
        }

        public Horse.Color getHorseColor() {
            return this.horseColor;
        }

        public String getChinese() {
            return this.chinese;
        }

        static {
            cachedValues = Color.values();
            colorLookup = new EnumMap<Horse.Color, Color>(Horse.Color.class);
            for (Color color : cachedValues) {
                colorLookup.put(color.getHorseColor(), color);
            }
        }
    }

    public static enum Style {
        BLACK_DOTS(Horse.Style.BLACK_DOTS, "\u9ed1\u8272\u6591\u70b9"),
        NONE(Horse.Style.NONE, "\u65e0"),
        WHITE(Horse.Style.WHITE, "\u767d\u8272"),
        WHITE_DOTS(Horse.Style.WHITE_DOTS, "\u767d\u8272\u6591\u70b9"),
        WHITEFIELD(Horse.Style.WHITEFIELD, "\u767d\u8272\u6761\u7eb9");

        private static final Style[] cachedValues;
        private static final Map<Horse.Style, Style> styleLookup;
        private final Horse.Style horseStyle;
        private final String chinese;

        @ParametersAreNonnullByDefault
        private Style(Horse.Style style, String chinese) {
            this.horseStyle = style;
            this.chinese = chinese;
        }

        @Nonnull
        public static Style fromStyle(@Nonnull Horse.Style horseStyle) {
            Preconditions.checkArgument((horseStyle != null ? 1 : 0) != 0, (Object)"\u9a6c\u7684\u6837\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
            return styleLookup.get(horseStyle);
        }

        public String toString() {
            return this.getChinese();
        }

        public Horse.Style getHorseStyle() {
            return this.horseStyle;
        }

        public String getChinese() {
            return this.chinese;
        }

        static {
            cachedValues = Style.values();
            styleLookup = new EnumMap<Horse.Style, Style>(Horse.Style.class);
            for (Style style : cachedValues) {
                styleLookup.put(style.getHorseStyle(), style);
            }
        }
    }
}

