/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.minecraft.helper.enchantments;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import net.guizhanss.guizhanlib.minecraft.LanguageHelper;
import net.guizhanss.guizhanlib.utils.StringUtil;
import org.bukkit.enchantments.Enchantment;

public final class EnchantmentHelper {
    @Nonnull
    public static String getEnchantmentDisplayName(@Nonnull Enchantment enchantment, int level) {
        Preconditions.checkArgument((enchantment != null ? 1 : 0) != 0, (Object)"\u9644\u9b54\u4e0d\u80fd\u4e3a\u7a7a");
        String name = EnchantmentHelper.getEnchantmentName(enchantment);
        String enchLevel = EnchantmentHelper.getEnchantmentLevelName(level);
        return name + (String)(enchLevel.length() > 0 ? " " + enchLevel : "");
    }

    @Nonnull
    public static String getEnchantmentDisplayName(@Nonnull Map.Entry<Enchantment, Integer> entry) {
        return EnchantmentHelper.getEnchantmentDisplayName(entry.getKey(), entry.getValue());
    }

    @Nonnull
    public static String getEnchantmentName(@Nonnull Enchantment enchantment) {
        return EnchantmentHelper.getEnchantmentName(enchantment, true);
    }

    @Nonnull
    public static String getEnchantmentName(@Nonnull Enchantment enchantment, boolean returnKey) {
        String enchantKey = EnchantmentHelper.getEnchantmentKey(enchantment);
        String enchant = LanguageHelper.getLangOrNull(enchantKey);
        if (enchant == null) {
            enchant = returnKey ? enchantKey : StringUtil.humanize(enchantment.getKey().getKey());
        }
        return enchant;
    }

    @Nonnull
    public static String getEnchantmentKey(@Nonnull Enchantment enchantment) {
        Preconditions.checkArgument((enchantment != null ? 1 : 0) != 0, (Object)"\u9644\u9b54\u4e0d\u80fd\u4e3a\u7a7a");
        return "enchantment.minecraft." + enchantment.getKey().getKey();
    }

    @Nonnull
    public static String getEnchantmentLevelName(int level) {
        return LanguageHelper.getLangOrKey(EnchantmentHelper.getEnchantmentLevelKey(level));
    }

    @Nonnull
    public static String getEnchantmentLevelKey(int level) {
        return "enchantment.level." + level;
    }

    private EnchantmentHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

