/*
 * Decompiled with CFR 0.152.
 */
package me.bunnky.slimevision.items.slimeeyes;

import fr.skytasul.glowingentities.GlowingBlocks;
import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotPlaceable;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.bunnky.slimevision.SlimeVision;
import me.bunnky.slimevision.utility.Utilities;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class SlimeEye
extends SimpleSlimefunItem<ItemUseHandler>
implements NotPlaceable,
Listener {
    protected final int r;
    protected final int cd;
    protected int cIdx = 0;
    protected final Map<UUID, Integer> msgCds = new HashMap<UUID, Integer>();
    protected final Map<UUID, Integer> prev = new HashMap<UUID, Integer>();
    protected final Map<UUID, Set<Block>> cachedBlocks = new HashMap<UUID, Set<Block>>();
    protected static final Map<UUID, BukkitRunnable> activeTasks = new HashMap<UUID, BukkitRunnable>();
    protected static final Map<UUID, Long> lastActionTime = new HashMap<UUID, Long>();
    protected static final ChatColor[] cOpts = new ChatColor[]{ChatColor.RED, ChatColor.DARK_RED, ChatColor.AQUA, ChatColor.DARK_AQUA, ChatColor.YELLOW, ChatColor.GREEN, ChatColor.DARK_GREEN, ChatColor.LIGHT_PURPLE, ChatColor.DARK_PURPLE, ChatColor.DARK_BLUE, ChatColor.BLUE, ChatColor.GRAY, ChatColor.DARK_GRAY, ChatColor.BLACK, ChatColor.WHITE};
    protected static final Set<String> users = new HashSet<String>();
    protected static final Map<String, Integer> slimeEyeUsage = new HashMap<String, Integer>();

    public SlimeEye(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int radius, int cooldown) {
        super(itemGroup, item, recipeType, recipe);
        this.r = radius;
        this.cd = cooldown;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)SlimeVision.getInstance());
        Bukkit.getServer().getScheduler().runTaskTimer((Plugin)SlimeVision.getInstance(), this::cleanCooldowns, 18000L, 18000L);
    }

    protected int getCooldown() {
        return this.cd;
    }

    @Nonnull
    public ItemUseHandler getItemHandler() {
        return this::onRightClick;
    }

    protected void onRightClick(@NotNull PlayerRightClickEvent e) {
        e.cancel();
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player p = e.getPlayer();
        UUID pUUID = p.getUniqueId();
        this.cachedBlocks.putIfAbsent(pUUID, new HashSet());
        if (p.isSneaking()) {
            this.cycleColor(p);
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (lastActionTime.containsKey(pUUID) && currentTime - lastActionTime.get(pUUID) < (long)this.getCooldown()) {
            long remainingTime = ((long)this.getCooldown() - (currentTime - lastActionTime.get(pUUID))) / 1000L;
            p.sendMessage("\u00a7cYou must wait " + remainingTime + " seconds.");
            return;
        }
        String typeName = this.getTypeName();
        slimeEyeUsage.put(typeName, slimeEyeUsage.getOrDefault(typeName, 0) + 1);
        users.add(p.getName());
        lastActionTime.put(pUUID, currentTime);
        this.cachedBlocks.remove(pUUID, this.cachedBlocks);
        this.startHighlight(p);
    }

    public static Set<String> getUsers() {
        return new HashSet<String>(users);
    }

    public static Map<String, Integer> getSlimeEyeUsage() {
        return new HashMap<String, Integer>(slimeEyeUsage);
    }

    public String getTypeName() {
        return "Slime Eye";
    }

    protected void cleanCooldowns() {
        long now = System.currentTimeMillis();
        lastActionTime.entrySet().removeIf(entry -> now - (Long)entry.getValue() > (long)this.cd);
    }

    protected void cycleColor(@NotNull Player p) {
        this.cIdx = (this.cIdx + 1) % (cOpts.length + 1);
        String colorName = this.cIdx == 0 ? "\u00a7eDefault" : Utilities.getColorName(cOpts[this.cIdx - 1]);
        p.sendMessage("\u00a7aGlow color set to: \u00a7e" + colorName);
    }

    protected void startHighlight(final @NotNull Player p) {
        UUID pUUID = p.getUniqueId();
        if (activeTasks.containsKey(pUUID)) {
            return;
        }
        p.sendMessage("\u00a76Slime Gaze enabled.");
        BukkitRunnable task = new BukkitRunnable(){

            public void run() {
                SlimeEye.this.checkBlocks(p, false);
            }
        };
        task.runTaskTimer((Plugin)SlimeVision.getInstance(), 0L, 20L);
        activeTasks.put(pUUID, task);
        Bukkit.getServer().getScheduler().runTaskLater((Plugin)SlimeVision.getInstance(), () -> {
            this.cancelHighlight(pUUID);
            p.sendMessage("\u00a7cSlime Gaze disabled.");
        }, 200L);
    }

    protected void cancelHighlight(UUID pUUID) {
        Player p;
        BukkitRunnable task = activeTasks.remove(pUUID);
        if (task != null) {
            task.cancel();
        }
        if ((p = Bukkit.getServer().getPlayer(pUUID)) != null) {
            for (Block b : this.cachedBlocks.get(pUUID)) {
                this.updateGlowingBlock(b, p, null, false);
            }
            this.cachedBlocks.remove(pUUID, this.cachedBlocks);
        }
    }

    protected void checkBlocks(@NotNull Player p, boolean inverted) {
        UUID pUUID = p.getUniqueId();
        Set<Block> cached = this.cachedBlocks.get(pUUID);
        World w = p.getWorld();
        Vector loc = Utilities.getPlayerVector(p);
        int pX = loc.getBlockX();
        int pY = loc.getBlockY();
        int pZ = loc.getBlockZ();
        int minX = pX - this.r;
        int minY = Utilities.getClampedCoordinate(pY, -this.r, -64, 320);
        int minZ = pZ - this.r;
        int maxX = pX + this.r;
        int maxY = Utilities.getClampedCoordinate(pY, this.r, -64, 320);
        int maxZ = pZ + this.r;
        HashSet<Block> currBlocks = new HashSet<Block>();
        ChatColor currentColor = this.cIdx == 0 ? ChatColor.GREEN : cOpts[this.cIdx - 1];
        for (Block b : cached) {
            if (this.isInRange(b, minX, minY, minZ, maxX, maxY, maxZ) && Utilities.hasBlockStorage(b) && !b.getType().isAir()) continue;
            this.updateGlowingBlock(b, p, currentColor, false);
        }
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    Block b = w.getBlockAt(x, y, z);
                    boolean isAirOrLiquid = Utilities.isAirOrLiquid(b);
                    if (inverted && !isAirOrLiquid || !inverted && isAirOrLiquid) continue;
                    if (cached.contains(b)) {
                        currBlocks.add(b);
                        this.updateGlowingBlock(b, p, currentColor, true);
                        continue;
                    }
                    if (!Utilities.hasBlockStorage(b)) continue;
                    cached.add(b);
                    currBlocks.add(b);
                    this.updateGlowingBlock(b, p, currentColor, true);
                }
            }
        }
        cached.retainAll(currBlocks);
        this.sendCountMessage(p, cached.size(), inverted);
    }

    protected void updateGlowingBlock(Block b, Player p, ChatColor c, boolean glow) {
        GlowingBlocks glowingBlocks = SlimeVision.getInstance().getGlowingBlocks();
        try {
            if (glow) {
                glowingBlocks.setGlowing(b, p, c);
            } else {
                glowingBlocks.unsetGlowing(b, p);
            }
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    protected boolean isInRange(Block b, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        int bX = b.getX();
        int bY = b.getY();
        int bZ = b.getZ();
        return bX >= minX && bX <= maxX && bY >= minY && bY <= maxY && bZ >= minZ && bZ <= maxZ;
    }

    protected void sendCountMessage(Player p, int total, boolean inverted) {
        UUID pUUID = p.getUniqueId();
        int currCd = this.msgCds.getOrDefault(pUUID, 0);
        int prevCnt = this.prev.getOrDefault(pUUID, 0);
        if (currCd > 0 && total == prevCnt) {
            this.msgCds.put(pUUID, currCd - 1);
            return;
        }
        StringBuilder m = new StringBuilder();
        m.append("\u00a7nIn Range:\n");
        if (inverted) {
            m.append("\u00a77Invisible: \u00a7e").append(total).append("\n");
        } else {
            m.append("\u00a7aValid: \u00a7e").append(total).append("\n");
        }
        m.append("\u00a7f\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\n");
        p.sendMessage(m.toString());
        this.msgCds.put(pUUID, 5);
        this.prev.put(pUUID, total);
    }

    @EventHandler
    protected void onPlayerQuit(PlayerQuitEvent e) {
        UUID pUUID = e.getPlayer().getUniqueId();
        if (activeTasks.containsKey(pUUID)) {
            this.cancelHighlight(pUUID);
            this.cachedBlocks.remove(pUUID, this.cachedBlocks);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        Player p = e.getPlayer();
        Block b = e.getBlock();
        this.updateGlowingBlock(b, p, null, false);
    }
}

