/*
 * Decompiled with CFR 0.152.
 */
package io.github.bakedlibs.dough.collections;

import io.github.bakedlibs.dough.collections.Streamable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class LoopIterator<T>
implements Iterator<T>,
Streamable<T> {
    private List<T> list;
    private int size;
    private int index = 0;

    public LoopIterator(@Nonnull Collection<T> collection) {
        this.init(collection);
    }

    public LoopIterator(@Nonnull Streamable<T> streamable) {
        if (streamable instanceof LoopIterator) {
            throw new IllegalArgumentException("Cannot loop-iterate over a LoopIterator");
        }
        this.init(streamable.stream().collect(Collectors.toList()));
    }

    private void init(Collection<T> collection) {
        this.size = collection.size();
        this.list = this.size > 0 ? new ArrayList<T>(collection) : null;
    }

    @Override
    public boolean hasNext() {
        return this.size > 0;
    }

    @Override
    public T next() {
        if (this.list == null) {
            throw new NoSuchElementException("The given collection was empty.");
        }
        if (this.index >= this.size) {
            this.index = 0;
        }
        return this.list.get(this.index++);
    }

    public Optional<T> find(@Nonnull Predicate<T> predicate) {
        if (!this.hasNext()) {
            return Optional.empty();
        }
        int start = this.index;
        T current = this.next();
        while (this.index != start || predicate.test(current)) {
            current = this.next();
        }
        if (predicate.test(current)) {
            return Optional.of(current);
        }
        return Optional.empty();
    }

    @Override
    public Stream<T> stream() {
        return Stream.generate(this::next);
    }

    public int getIndex() {
        return this.index;
    }
}

