/*
 * Decompiled with CFR 0.152.
 */
package me.bunnky.slimevision.items;

import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.bunnky.slimevision.items.slimeeyes.SlimeEyeInverted;
import me.bunnky.slimevision.utility.Utilities;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class SlimeScribe
extends SlimeEyeInverted {
    public SlimeScribe(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int radius, int cooldown) {
        super(itemGroup, item, recipeType, recipe, radius, cooldown);
    }

    @Override
    public String getTypeName() {
        return "Slime Scribe";
    }

    protected ItemStack createBook(Player p, List<Block> found) {
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
        BookMeta meta = (BookMeta)book.getItemMeta();
        meta.setTitle("[SV] Invisible Machine Locations");
        meta.setAuthor(p.getName());
        StringBuilder firstPage = new StringBuilder();
        firstPage.append("Player Location\n").append(p.getLocation().getBlockX()).append(", ").append(p.getLocation().getBlockY()).append(", ").append(p.getLocation().getBlockZ()).append("\n\n");
        for (int i = 0; i < found.size(); ++i) {
            Block b = found.get(i);
            firstPage.append(i + 1).append(". ").append(b.getX()).append(", ").append(b.getY()).append(", ").append(b.getZ()).append("\n");
            if (firstPage.toString().split("\n").length < 14) continue;
            meta.addPage(new String[]{firstPage.toString()});
            firstPage = new StringBuilder();
        }
        if (!firstPage.isEmpty()) {
            meta.addPage(new String[]{firstPage.toString()});
        }
        book.setItemMeta((ItemMeta)meta);
        return book;
    }

    @Override
    protected void onRightClick(@NotNull PlayerRightClickEvent e) {
        e.cancel();
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player p = e.getPlayer();
        if (p.getInventory().firstEmpty() == -1) {
            p.sendMessage("\u00a7cInventory full.");
            return;
        }
        UUID pUUID = p.getUniqueId();
        Long lastTime = (Long)lastActionTime.get(pUUID);
        long currentTime = System.currentTimeMillis();
        int cooldown = this.getCooldown();
        if (lastTime != null && currentTime - lastTime < (long)cooldown) {
            long remainingTime = ((long)cooldown - (currentTime - lastTime)) / 1000L;
            p.sendMessage("\u00a7cYou must wait " + remainingTime + " seconds.");
            return;
        }
        String typeName = this.getTypeName();
        slimeEyeUsage.put(typeName, slimeEyeUsage.getOrDefault(typeName, 0) + 1);
        users.add(p.getName());
        lastActionTime.put(pUUID, currentTime);
        List<Block> foundMachines = this.checkArea(p);
        if (foundMachines.isEmpty()) {
            p.sendMessage("\u00a7cNo invisible machines found.");
        } else {
            ItemStack book = this.createBook(p, foundMachines);
            p.getInventory().addItem(new ItemStack[]{book});
            p.sendMessage("\u00a7aInvisible machine locations have been written to a book.");
        }
    }

    protected List<Block> checkArea(@NotNull Player p) {
        World w = p.getWorld();
        Vector loc = Utilities.getPlayerVector(p);
        int pX = loc.getBlockX();
        int pY = loc.getBlockY();
        int pZ = loc.getBlockZ();
        int minX = pX - this.r;
        int minY = Utilities.getClampedCoordinate(pY, -this.r, -64, 320);
        int minZ = pZ - this.r;
        int maxX = pX + this.r;
        int maxY = Utilities.getClampedCoordinate(pY, this.r, -64, 320);
        int maxZ = pZ + this.r;
        ArrayList<Block> foundMachines = new ArrayList<Block>();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    Block b = w.getBlockAt(x, y, z);
                    if (!Utilities.hasBlockStorage(b) || !Utilities.isAirOrLiquid(b)) continue;
                    foundMachines.add(b);
                }
            }
        }
        return foundMachines;
    }
}

