/*
 * Decompiled with CFR 0.152.
 */
package me.bunnky.slimevision.items;

import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotPlaceable;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import javax.annotation.Nonnull;
import me.bunnky.slimevision.SlimeVision;
import me.bunnky.slimevision.utility.Utilities;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class ParticleItem
extends SimpleSlimefunItem<ItemUseHandler>
implements NotPlaceable {
    private final Color particleColor;

    public ParticleItem(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Color color) {
        super(itemGroup, item, recipeType, recipe);
        this.particleColor = color;
    }

    @Nonnull
    public ItemUseHandler getItemHandler() {
        return this::onRightClick;
    }

    private void onRightClick(@NotNull PlayerRightClickEvent e) {
        e.cancel();
        final Player p = e.getPlayer();
        ItemStack i = p.getInventory().getItemInMainHand();
        ItemStack o = p.getInventory().getItemInOffHand();
        if (Utilities.isParticleItem(i) || Utilities.isParticleItem(o)) {
            final Location start = p.getEyeLocation();
            final Vector dir = start.getDirection();
            p.getWorld().playSound(start, Sound.ENTITY_ENDER_EYE_DEATH, 1.0f, 1.0f);
            new BukkitRunnable(){
                Location loc;
                static final double DISTANCE = 5.0;
                static final double SPEED = 0.5;
                double traveled;
                {
                    this.loc = start.clone();
                    this.traveled = 0.0;
                }

                public void run() {
                    if (this.traveled >= 5.0) {
                        this.cancel();
                        return;
                    }
                    this.loc.add(dir.clone().multiply(0.5));
                    p.getWorld().spawnParticle(Particle.REDSTONE, this.loc, 0, (Object)new Particle.DustOptions(ParticleItem.this.particleColor, 1.0f));
                    this.traveled += 0.5;
                }
            }.runTaskTimer((Plugin)SlimeVision.getInstance(), 0L, 1L);
        }
    }
}

