/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.glowingentities;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class GlowingEntities
implements Listener {
    @NotNull
    protected final Plugin plugin;
    private Map<Player, PlayerData> glowing;
    boolean enabled = false;
    private int uid;

    public GlowingEntities(@NotNull Plugin plugin) {
        if (!Packets.enabled) {
            throw new IllegalStateException("The Glowing Entities API is disabled. An error has occured during initialization.");
        }
        this.plugin = Objects.requireNonNull(plugin);
        this.enable();
    }

    public void enable() {
        if (this.enabled) {
            throw new IllegalStateException("The Glowing Entities API has already been enabled.");
        }
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, this.plugin);
        this.glowing = new HashMap<Player, PlayerData>();
        this.uid = ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE);
        this.enabled = true;
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        HandlerList.unregisterAll((Listener)this);
        this.glowing.values().forEach(playerData -> {
            try {
                Packets.removePacketsHandler(playerData);
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        });
        this.glowing = null;
        this.uid = 0;
        this.enabled = false;
    }

    private void ensureEnabled() {
        if (!this.enabled) {
            throw new IllegalStateException("The Glowing Entities API is not enabled.");
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.glowing.remove(event.getPlayer());
    }

    public void setGlowing(Entity entity, Player receiver) throws ReflectiveOperationException {
        this.setGlowing(entity, receiver, null);
    }

    public void setGlowing(Entity entity, Player receiver, ChatColor color) throws ReflectiveOperationException {
        String teamID = entity instanceof Player ? entity.getName() : entity.getUniqueId().toString();
        this.setGlowing(entity.getEntityId(), teamID, receiver, color, Packets.getEntityFlags(entity));
    }

    public void setGlowing(int entityID, String teamID, Player receiver) throws ReflectiveOperationException {
        this.setGlowing(entityID, teamID, receiver, null, (byte)0);
    }

    public void setGlowing(int entityID, String teamID, Player receiver, ChatColor color) throws ReflectiveOperationException {
        this.setGlowing(entityID, teamID, receiver, color, (byte)0);
    }

    public void setGlowing(int entityID, String teamID, Player receiver, ChatColor color, byte otherFlags) throws ReflectiveOperationException {
        GlowingData glowingData;
        this.ensureEnabled();
        if (color != null && !color.isColor()) {
            throw new IllegalArgumentException("ChatColor must be a color format");
        }
        PlayerData playerData = this.glowing.get(receiver);
        if (playerData == null) {
            playerData = new PlayerData(this, receiver);
            Packets.addPacketsHandler(playerData);
            this.glowing.put(receiver, playerData);
        }
        if ((glowingData = playerData.glowingDatas.get(entityID)) == null) {
            glowingData = new GlowingData(playerData, entityID, teamID, color, otherFlags);
            playerData.glowingDatas.put(entityID, glowingData);
            Packets.createGlowing(glowingData);
            if (color != null) {
                Packets.setGlowingColor(glowingData);
            }
        } else {
            if (Objects.equals(glowingData.color, color)) {
                return;
            }
            if (color == null) {
                Packets.removeGlowingColor(glowingData);
                glowingData.color = color;
            } else {
                glowingData.color = color;
                Packets.setGlowingColor(glowingData);
            }
        }
    }

    public void unsetGlowing(Entity entity, Player receiver) throws ReflectiveOperationException {
        this.unsetGlowing(entity.getEntityId(), receiver);
    }

    public void unsetGlowing(int entityID, Player receiver) throws ReflectiveOperationException {
        this.ensureEnabled();
        PlayerData playerData = this.glowing.get(receiver);
        if (playerData == null) {
            return;
        }
        GlowingData glowingData = playerData.glowingDatas.remove(entityID);
        if (glowingData == null) {
            return;
        }
        Packets.removeGlowing(glowingData);
        if (glowingData.color != null) {
            Packets.removeGlowingColor(glowingData);
        }
    }

    protected static class Packets {
        private static final byte GLOWING_FLAG = 64;
        private static Cache<Object, Object> packets = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).build();
        private static Object dummy = new Object();
        private static Logger logger;
        private static int version;
        private static int versionMinor;
        private static String cpack;
        private static ProtocolMappings mappings;
        public static boolean enabled;
        private static Method getHandle;
        private static Method getDataWatcher;
        private static Object watcherObjectFlags;
        private static Object watcherDummy;
        private static Method watcherGet;
        private static Constructor<?> watcherItemConstructor;
        private static Method watcherItemObject;
        private static Method watcherItemDataGet;
        private static Method watcherBCreator;
        private static Method watcherBId;
        private static Method watcherBSerializer;
        private static Method watcherSerializerObject;
        private static Field playerConnection;
        private static Method sendPacket;
        private static Field networkManager;
        private static Field channelField;
        private static Class<?> packetBundle;
        private static Method packetBundlePackets;
        private static Class<?> packetMetadata;
        private static Constructor<?> packetMetadataConstructor;
        private static Field packetMetadataEntity;
        private static Field packetMetadataItems;
        private static EnumMap<ChatColor, TeamData> teams;
        private static Constructor<?> createTeamPacket;
        private static Constructor<?> createTeamPacketData;
        private static Constructor<?> createTeam;
        private static Object scoreboardDummy;
        private static Object pushNever;
        private static Method setTeamPush;
        private static Method setTeamColor;
        private static Method getColorConstant;
        static Object shulkerEntityType;
        private static Constructor<?> packetAddEntity;
        private static Constructor<?> packetRemove;
        private static Object vec3dZero;

        protected Packets() {
        }

        public static void sendPackets(Player p, Object ... packets) throws ReflectiveOperationException {
            Object connection = playerConnection.get(getHandle.invoke((Object)p, new Object[0]));
            for (Object packet : packets) {
                if (packet == null) continue;
                sendPacket.invoke(connection, packet);
            }
        }

        public static byte getEntityFlags(Entity entity) throws ReflectiveOperationException {
            Object nmsEntity = getHandle.invoke((Object)entity, new Object[0]);
            Object dataWatcher = getDataWatcher.invoke(nmsEntity, new Object[0]);
            return (Byte)watcherGet.invoke(dataWatcher, watcherObjectFlags);
        }

        public static void createGlowing(GlowingData glowingData) throws ReflectiveOperationException {
            Packets.setMetadata(glowingData.player.player, glowingData.entityID, Packets.computeFlags(glowingData), true);
        }

        private static byte computeFlags(GlowingData glowingData) {
            byte newFlags = glowingData.otherFlags;
            newFlags = glowingData.enabled ? (byte)(newFlags | 0x40) : (byte)(newFlags & 0xFFFFFFBF);
            return newFlags;
        }

        public static Object createFlagWatcherItem(byte newFlags) throws ReflectiveOperationException {
            return watcherItemConstructor != null ? watcherItemConstructor.newInstance(watcherObjectFlags, newFlags) : watcherBCreator.invoke(null, watcherObjectFlags, newFlags);
        }

        public static void removeGlowing(GlowingData glowingData) throws ReflectiveOperationException {
            Packets.setMetadata(glowingData.player.player, glowingData.entityID, glowingData.otherFlags, true);
        }

        public static void updateGlowingState(GlowingData glowingData) throws ReflectiveOperationException {
            if (glowingData.enabled) {
                Packets.createGlowing(glowingData);
            } else {
                Packets.removeGlowing(glowingData);
            }
        }

        public static void setMetadata(Player player, int entityId, byte flags, boolean ignore) throws ReflectiveOperationException {
            Object packetMetadata;
            ArrayList dataItems = new ArrayList(1);
            dataItems.add(watcherItemConstructor != null ? watcherItemConstructor.newInstance(watcherObjectFlags, flags) : watcherBCreator.invoke(null, watcherObjectFlags, flags));
            if (version < 19 || version == 19 && versionMinor < 3) {
                packetMetadata = packetMetadataConstructor.newInstance(entityId, watcherDummy, false);
                packetMetadataItems.set(packetMetadata, dataItems);
            } else {
                packetMetadata = packetMetadataConstructor.newInstance(entityId, dataItems);
            }
            if (ignore) {
                packets.put(packetMetadata, dummy);
            }
            Packets.sendPackets(player, packetMetadata);
        }

        public static void setGlowingColor(GlowingData glowingData) throws ReflectiveOperationException {
            boolean sendCreation = false;
            if (glowingData.player.sentColors == null) {
                glowingData.player.sentColors = EnumSet.of(glowingData.color);
                sendCreation = true;
            } else if (glowingData.player.sentColors.add(glowingData.color)) {
                sendCreation = true;
            }
            TeamData teamData = teams.get(glowingData.color);
            if (teamData == null) {
                teamData = new TeamData(glowingData.player.instance.uid, glowingData.color);
                teams.put(glowingData.color, teamData);
            }
            Object entityAddPacket = teamData.getEntityAddPacket(glowingData.teamID);
            if (sendCreation) {
                Packets.sendPackets(glowingData.player.player, teamData.creationPacket, entityAddPacket);
            } else {
                Packets.sendPackets(glowingData.player.player, entityAddPacket);
            }
        }

        public static void removeGlowingColor(GlowingData glowingData) throws ReflectiveOperationException {
            TeamData teamData = teams.get(glowingData.color);
            if (teamData == null) {
                return;
            }
            Packets.sendPackets(glowingData.player.player, teamData.getEntityRemovePacket(glowingData.teamID));
        }

        public static void createEntity(Player player, int entityId, UUID entityUuid, Object entityType, Location location) throws IllegalArgumentException, ReflectiveOperationException {
            Object packet = version >= 19 ? packetAddEntity.newInstance(entityId, entityUuid, location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getPitch()), Float.valueOf(location.getYaw()), entityType, 0, vec3dZero, 0.0) : packetAddEntity.newInstance(entityId, entityUuid, location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getPitch()), Float.valueOf(location.getYaw()), entityType, 0, vec3dZero);
            Packets.sendPackets(player, packet);
        }

        public static void removeEntities(Player player, int ... entitiesId) throws ReflectiveOperationException {
            Object[] packets;
            if (version == 17 && versionMinor == 0) {
                packets = new Object[entitiesId.length];
                for (int i = 0; i < entitiesId.length; ++i) {
                    packets[i] = packetRemove.newInstance(entitiesId[i]);
                }
            } else {
                packets = new Object[]{packetRemove.newInstance(new Object[]{entitiesId})};
            }
            Packets.sendPackets(player, packets);
        }

        private static Channel getChannel(Player player) throws ReflectiveOperationException {
            return (Channel)channelField.get(networkManager.get(playerConnection.get(getHandle.invoke((Object)player, new Object[0]))));
        }

        public static void addPacketsHandler(final PlayerData playerData) throws ReflectiveOperationException {
            playerData.packetsHandler = new ChannelDuplexHandler(){

                public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                    if (msg.getClass().equals(packetMetadata) && packets.asMap().remove(msg) == null) {
                        ArrayList<Object> items;
                        int entityID = packetMetadataEntity.getInt(msg);
                        GlowingData glowingData = playerData.glowingDatas.get(entityID);
                        if (glowingData != null && (items = (ArrayList<Object>)packetMetadataItems.get(msg)) != null) {
                            byte flags;
                            boolean containsFlags = false;
                            boolean edited = false;
                            for (int i = 0; i < items.size(); ++i) {
                                byte flags2;
                                Object watcherObject;
                                Object item = items.get(i);
                                if (watcherItemObject != null) {
                                    watcherObject = watcherItemObject.invoke(item, new Object[0]);
                                } else {
                                    Object serializer = watcherBSerializer.invoke(item, new Object[0]);
                                    watcherObject = watcherSerializerObject.invoke(serializer, watcherBId.invoke(item, new Object[0]));
                                }
                                if (!watcherObject.equals(watcherObjectFlags)) continue;
                                containsFlags = true;
                                glowingData.otherFlags = flags2 = ((Byte)watcherItemDataGet.invoke(item, new Object[0])).byteValue();
                                byte newFlags = Packets.computeFlags(glowingData);
                                if (newFlags == flags2) continue;
                                edited = true;
                                items = new ArrayList(items);
                                items.set(i, Packets.createFlagWatcherItem(newFlags));
                                break;
                            }
                            if (!edited && !containsFlags && (flags = Packets.computeFlags(glowingData)) != 0) {
                                edited = true;
                                items = new ArrayList<Object>(items);
                                items.add(Packets.createFlagWatcherItem(flags));
                            }
                            if (edited) {
                                Object newMsg;
                                if (version < 19 || version == 19 && versionMinor < 3) {
                                    newMsg = packetMetadataConstructor.newInstance(entityID, watcherDummy, false);
                                    packetMetadataItems.set(newMsg, items);
                                } else {
                                    newMsg = packetMetadataConstructor.newInstance(entityID, items);
                                }
                                packets.put(newMsg, dummy);
                                Packets.sendPackets(playerData.player, newMsg);
                                return;
                            }
                        }
                    } else if (packetBundle != null && msg.getClass().equals(packetBundle)) {
                        this.handlePacketBundle(msg);
                    }
                    super.write(ctx, msg, promise);
                }

                private void handlePacketBundle(Object bundle) throws ReflectiveOperationException {
                    Iterable subPackets = (Iterable)packetBundlePackets.invoke(bundle, new Object[0]);
                    for (Object packet : subPackets) {
                        int entityID;
                        GlowingData glowingData;
                        if (!packet.getClass().equals(packetMetadata) || (glowingData = playerData.glowingDatas.get(entityID = packetMetadataEntity.getInt(packet))) == null) continue;
                        Bukkit.getScheduler().runTaskLaterAsynchronously(playerData.instance.plugin, () -> {
                            try {
                                Packets.updateGlowingState(glowingData);
                            }
                            catch (ReflectiveOperationException e) {
                                e.printStackTrace();
                            }
                        }, 1L);
                        return;
                    }
                }
            };
            Packets.getChannel(playerData.player).pipeline().addBefore("packet_handler", null, playerData.packetsHandler);
        }

        public static void removePacketsHandler(PlayerData playerData) throws ReflectiveOperationException {
            if (playerData.packetsHandler != null) {
                Packets.getChannel(playerData.player).pipeline().remove(playerData.packetsHandler);
            }
        }

        @Deprecated
        private static Object getField(Class<?> clazz, String name, Object instance) throws ReflectiveOperationException {
            return Packets.getField(clazz, name).get(instance);
        }

        private static Field getField(Class<?> clazz, String name) throws ReflectiveOperationException {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }

        private static Field getInheritedField(Class<?> clazz, String name) throws ReflectiveOperationException {
            Class<?> superclass = clazz;
            while (true) {
                try {
                    Field field = superclass.getDeclaredField(name);
                    field.setAccessible(true);
                    return field;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    if ((superclass = clazz.getSuperclass()) != null) continue;
                    throw new NoSuchFieldException(name);
                }
                break;
            }
        }

        private static Class<?> getCraftClass(String craftPackage, String className) throws ClassNotFoundException {
            return Class.forName(cpack + craftPackage + "." + className);
        }

        private static Class<?> getNMSClass(String className) throws ClassNotFoundException {
            return Class.forName("net.minecraft." + className);
        }

        private static Class<?> getNMSClass(String nmPackage, String className) throws ClassNotFoundException {
            return Class.forName("net.minecraft." + nmPackage + "." + className);
        }

        static {
            cpack = Bukkit.getServer().getClass().getPackage().getName() + ".";
            enabled = false;
            teams = new EnumMap(ChatColor.class);
            try {
                logger = new Logger("GlowingEntities", null){

                    @Override
                    public void log(LogRecord logRecord) {
                        logRecord.setMessage("[GlowingEntities] " + logRecord.getMessage());
                        super.log(logRecord);
                    }
                };
                logger.setParent(Bukkit.getServer().getLogger());
                logger.setLevel(Level.ALL);
                String[] versions = Bukkit.getBukkitVersion().split("-R")[0].split("\\.");
                version = Integer.parseInt(versions[1]);
                versionMinor = versions.length <= 2 ? 0 : Integer.parseInt(versions[2]);
                logger.info("Found server version 1." + version + "." + versionMinor);
                boolean remapped = Bukkit.getServer().getClass().getPackage().getName().split("\\.").length == 3;
                mappings = ProtocolMappings.getMappings(version, versionMinor, remapped);
                if (mappings == null) {
                    mappings = ProtocolMappings.getLast(remapped);
                    logger.warning("Loaded not matching version of the mappings for your server version");
                }
                logger.info("Loaded mappings " + mappings.name());
                Class<?> entityClass = Packets.getNMSClass("world.entity", "Entity");
                Class<?> entityTypesClass = Packets.getNMSClass("world.entity", "EntityTypes");
                Object markerEntity = Packets.getNMSClass("world.entity", "Marker").getDeclaredConstructors()[0].newInstance(Packets.getField(entityTypesClass, mappings.getMarkerTypeId(), null), null);
                getHandle = Packets.getCraftClass("entity", "CraftEntity").getDeclaredMethod("getHandle", new Class[0]);
                getDataWatcher = entityClass.getDeclaredMethod(mappings.getWatcherAccessor(), new Class[0]);
                Class<?> dataWatcherClass = Packets.getNMSClass("network.syncher", "DataWatcher");
                if (version > 20 || version == 20 && versionMinor >= 5) {
                    Object watcherBuilder = Packets.getNMSClass("network.syncher", "DataWatcher$a").getDeclaredConstructor(Packets.getNMSClass("network.syncher", "SyncedDataHolder")).newInstance(markerEntity);
                    Field watcherBuilderItems = watcherBuilder.getClass().getDeclaredField(remapped ? "itemsById" : "b");
                    watcherBuilderItems.setAccessible(true);
                    watcherBuilderItems.set(watcherBuilder, Array.newInstance(watcherBuilderItems.getType().componentType(), 0));
                    watcherDummy = watcherBuilder.getClass().getDeclaredMethod(remapped ? "build" : "a", new Class[0]).invoke(watcherBuilder, new Object[0]);
                } else {
                    Class[] watcherConstructorArgsType = new Class[]{entityClass};
                    Object[] watcherConstructorArgs = new Object[]{markerEntity};
                    watcherDummy = dataWatcherClass.getDeclaredConstructor(watcherConstructorArgsType).newInstance(watcherConstructorArgs);
                }
                watcherObjectFlags = Packets.getField(entityClass, mappings.getWatcherFlags(), null);
                watcherGet = dataWatcherClass.getDeclaredMethod(mappings.getWatcherGet(), watcherObjectFlags.getClass());
                if (version < 19 || version == 19 && versionMinor < 3) {
                    Class<?> watcherItem = Packets.getNMSClass("network.syncher", "DataWatcher$Item");
                    watcherItemConstructor = watcherItem.getDeclaredConstructor(watcherObjectFlags.getClass(), Object.class);
                    watcherItemObject = watcherItem.getDeclaredMethod("a", new Class[0]);
                    watcherItemDataGet = watcherItem.getDeclaredMethod("b", new Class[0]);
                } else {
                    String subclass = version > 20 || version == 20 && versionMinor >= 5 ? "c" : "b";
                    Class<?> watcherB = Packets.getNMSClass("network.syncher", "DataWatcher$" + subclass);
                    watcherBCreator = watcherB.getDeclaredMethod("a", watcherObjectFlags.getClass(), Object.class);
                    watcherBId = watcherB.getDeclaredMethod("a", new Class[0]);
                    watcherBSerializer = watcherB.getDeclaredMethod("b", new Class[0]);
                    watcherItemDataGet = watcherB.getDeclaredMethod("c", new Class[0]);
                    watcherSerializerObject = Packets.getNMSClass("network.syncher", "DataWatcherSerializer").getDeclaredMethod("a", Integer.TYPE);
                }
                playerConnection = Packets.getField(Packets.getNMSClass("server.level", "EntityPlayer"), mappings.getPlayerConnection());
                sendPacket = Packets.getNMSClass("server.network", "PlayerConnection").getMethod(mappings.getSendPacket(), Packets.getNMSClass("network.protocol", "Packet"));
                networkManager = Packets.getInheritedField(Packets.getNMSClass("server.network", "PlayerConnection"), mappings.getNetworkManager());
                channelField = Packets.getField(Packets.getNMSClass("network", "NetworkManager"), mappings.getChannel());
                if (version > 19 || version == 19 && versionMinor >= 4) {
                    packetBundle = Packets.getNMSClass("network.protocol.game", "ClientboundBundlePacket");
                    packetBundlePackets = packetBundle.getMethod(version > 20 || version == 20 && versionMinor >= 5 ? "b" : "a", new Class[0]);
                }
                packetMetadata = Packets.getNMSClass("network.protocol.game", "PacketPlayOutEntityMetadata");
                packetMetadataEntity = Packets.getField(packetMetadata, mappings.getMetadataEntity());
                packetMetadataItems = Packets.getField(packetMetadata, mappings.getMetadataItems());
                packetMetadataConstructor = version < 19 || version == 19 && versionMinor < 3 ? packetMetadata.getDeclaredConstructor(Integer.TYPE, dataWatcherClass, Boolean.TYPE) : packetMetadata.getDeclaredConstructor(Integer.TYPE, List.class);
                Class<?> scoreboardClass = Packets.getNMSClass("world.scores", "Scoreboard");
                Class<?> teamClass = Packets.getNMSClass("world.scores", "ScoreboardTeam");
                Class<?> pushClass = Packets.getNMSClass("world.scores", "ScoreboardTeamBase$EnumTeamPush");
                Class<?> chatFormatClass = Packets.getNMSClass("EnumChatFormat");
                createTeamPacket = Packets.getNMSClass("network.protocol.game", "PacketPlayOutScoreboardTeam").getDeclaredConstructor(String.class, Integer.TYPE, Optional.class, Collection.class);
                createTeamPacket.setAccessible(true);
                createTeamPacketData = Packets.getNMSClass("network.protocol.game", "PacketPlayOutScoreboardTeam$b").getDeclaredConstructor(teamClass);
                createTeam = teamClass.getDeclaredConstructor(scoreboardClass, String.class);
                scoreboardDummy = scoreboardClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                pushNever = pushClass.getDeclaredField("b").get(null);
                setTeamPush = teamClass.getDeclaredMethod(mappings.getTeamSetCollision(), pushClass);
                setTeamColor = teamClass.getDeclaredMethod(mappings.getTeamSetColor(), chatFormatClass);
                getColorConstant = chatFormatClass.getDeclaredMethod("a", Character.TYPE);
                Class<?> shulkerClass = Packets.getNMSClass("world.entity.monster", "EntityShulker");
                for (Field field : entityTypesClass.getDeclaredFields()) {
                    ParameterizedType fieldType;
                    if (field.getType() != entityTypesClass || (fieldType = (ParameterizedType)field.getGenericType()).getActualTypeArguments()[0] != shulkerClass) continue;
                    shulkerEntityType = field.get(null);
                    break;
                }
                if (shulkerEntityType == null) {
                    throw new IllegalStateException();
                }
                Class<?> vec3dClass = Packets.getNMSClass("world.phys", "Vec3D");
                vec3dZero = vec3dClass.getConstructor(Double.TYPE, Double.TYPE, Double.TYPE).newInstance(0.0, 0.0, 0.0);
                packetAddEntity = version >= 19 ? Packets.getNMSClass("network.protocol.game", "PacketPlayOutSpawnEntity").getDeclaredConstructor(Integer.TYPE, UUID.class, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE, entityTypesClass, Integer.TYPE, vec3dClass, Double.TYPE) : Packets.getNMSClass("network.protocol.game", "PacketPlayOutSpawnEntity").getDeclaredConstructor(Integer.TYPE, UUID.class, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE, entityTypesClass, Integer.TYPE, vec3dClass);
                packetRemove = Packets.getNMSClass("network.protocol.game", "PacketPlayOutEntityDestroy").getDeclaredConstructor(version == 17 && versionMinor == 0 ? Integer.TYPE : int[].class);
                enabled = true;
            }
            catch (Exception ex) {
                String errorMsg = "Glowing Entities reflection failed to initialize. The util is disabled. Please ensure your version (" + Bukkit.getServer().getClass().getPackage().getName() + ") is supported.";
                if (logger == null) {
                    ex.printStackTrace();
                    System.err.println(errorMsg);
                }
                logger.log(Level.SEVERE, errorMsg, ex);
            }
        }

        private static class TeamData {
            private final String id;
            private final Object creationPacket;
            private final Cache<String, Object> addPackets = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.MINUTES).build();
            private final Cache<String, Object> removePackets = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.MINUTES).build();

            public TeamData(int uid, ChatColor color) throws ReflectiveOperationException {
                if (!color.isColor()) {
                    throw new IllegalArgumentException();
                }
                this.id = "glow-" + uid + color.getChar();
                Object team = createTeam.newInstance(scoreboardDummy, this.id);
                setTeamPush.invoke(team, pushNever);
                setTeamColor.invoke(team, getColorConstant.invoke(null, Character.valueOf(color.getChar())));
                Object packetData = createTeamPacketData.newInstance(team);
                this.creationPacket = createTeamPacket.newInstance(this.id, 0, Optional.of(packetData), Collections.EMPTY_LIST);
            }

            public Object getEntityAddPacket(String teamID) throws ReflectiveOperationException {
                Object packet = this.addPackets.getIfPresent((Object)teamID);
                if (packet == null) {
                    packet = createTeamPacket.newInstance(this.id, 3, Optional.empty(), Arrays.asList(teamID));
                    this.addPackets.put((Object)teamID, packet);
                }
                return packet;
            }

            public Object getEntityRemovePacket(String teamID) throws ReflectiveOperationException {
                Object packet = this.removePackets.getIfPresent((Object)teamID);
                if (packet == null) {
                    packet = createTeamPacket.newInstance(this.id, 4, Optional.empty(), Arrays.asList(teamID));
                    this.removePackets.put((Object)teamID, packet);
                }
                return packet;
            }
        }

        private static enum ProtocolMappings {
            V1_17(17, 0, false, "Z", "Y", "getDataWatcher", "get", "b", "a", "sendPacket", "k", "setCollisionRule", "setColor", "a", "b"),
            V1_18(18, 0, false, "Z", "Y", "ai", "a", "b", "a", "a", "m", "a", "a", "a", "b"),
            V1_19(19, 0, false, "Z", "ab", "ai", null, "b", "b", "a", "m", "a", "a", "a", "b"),
            V1_19_3(19, 3, false, null, null, "al", null, null, null, null, null, null, null, "b", "c"),
            V1_19_4(19, 4, false, "an", null, "aj", null, null, "h", null, null, null, null, null, null),
            V1_20(20, 0, false, "an", "am", "aj", "b", "c", "h", "a", "m", "a", "a", "b", "c"),
            V1_20_2(20, 2, false, "ao", null, "al", null, null, "c", "b", "n", null, null, null, null),
            V1_20_3(20, 3, false, null, "an", "an", null, null, null, null, null, null, null, null, null),
            V1_20_5(20, 5, false, "ap", "aq", "ap", "a", null, "e", null, null, null, null, "c", "d"),
            V1_20_5_REMAPPED(20, 5, true, "DATA_SHARED_FLAGS_ID", "MARKER", "getEntityData", "get", "connection", "connection", "send", "channel", "setCollisionRule", "setColor", "id", "packedItems"),
            V1_21(21, 0, false, null, null, "ar", null, null, null, null, null, null, null, null, null);

            private final int major;
            private final int minor;
            private final boolean remapped;
            private String watcherFlags;
            private String markerTypeId;
            private String watcherAccessor;
            private String watcherGet;
            private String playerConnection;
            private String networkManager;
            private String sendPacket;
            private String channel;
            private String teamSetCollsion;
            private String teamSetColor;
            private String metadataEntity;
            private String metadataItems;

            private ProtocolMappings(int major, int minor, boolean remapped, String watcherFlags, String markerTypeId, String watcherAccessor, String watcherGet, String playerConnection, String networkManager, String sendPacket, String channel, String teamSetCollsion, String teamSetColor, String metdatataEntity, String metadataItems) {
                this.major = major;
                this.minor = minor;
                this.remapped = remapped;
                this.watcherFlags = watcherFlags;
                this.markerTypeId = markerTypeId;
                this.watcherAccessor = watcherAccessor;
                this.watcherGet = watcherGet;
                this.playerConnection = playerConnection;
                this.networkManager = networkManager;
                this.sendPacket = sendPacket;
                this.channel = channel;
                this.teamSetCollsion = teamSetCollsion;
                this.teamSetColor = teamSetColor;
                this.metadataEntity = metdatataEntity;
                this.metadataItems = metadataItems;
            }

            public int getMajor() {
                return this.major;
            }

            public int getMinor() {
                return this.minor;
            }

            public boolean isRemapped() {
                return this.remapped;
            }

            public String getWatcherFlags() {
                return this.watcherFlags;
            }

            public String getMarkerTypeId() {
                return this.markerTypeId;
            }

            public String getWatcherAccessor() {
                return this.watcherAccessor;
            }

            public String getWatcherGet() {
                return this.watcherGet;
            }

            public String getPlayerConnection() {
                return this.playerConnection;
            }

            public String getNetworkManager() {
                return this.networkManager;
            }

            public String getSendPacket() {
                return this.sendPacket;
            }

            public String getChannel() {
                return this.channel;
            }

            public String getTeamSetCollision() {
                return this.teamSetCollsion;
            }

            public String getTeamSetColor() {
                return this.teamSetColor;
            }

            public String getMetadataEntity() {
                return this.metadataEntity;
            }

            public String getMetadataItems() {
                return this.metadataItems;
            }

            private static void fillAll() throws ReflectiveOperationException {
                ProtocolMappings lastUnmapped = V1_17;
                ProtocolMappings lastRemapped = V1_20_5_REMAPPED;
                for (int i = 1; i < ProtocolMappings.values().length; ++i) {
                    ProtocolMappings map = ProtocolMappings.values()[i];
                    for (Field field : ProtocolMappings.class.getDeclaredFields()) {
                        if (field.getType() != String.class || field.get((Object)map) != null) continue;
                        field.set((Object)map, field.get((Object)(map.isRemapped() ? lastRemapped : lastUnmapped)));
                    }
                    if (map.isRemapped()) {
                        lastRemapped = map;
                        continue;
                    }
                    lastUnmapped = map;
                }
            }

            public static ProtocolMappings getMappings(int major, int minor, boolean remapped) {
                ProtocolMappings lastGood = null;
                for (ProtocolMappings map : ProtocolMappings.values()) {
                    if (map.isRemapped() != remapped || major != map.getMajor()) continue;
                    if (minor == map.getMinor()) {
                        return map;
                    }
                    if (minor > map.getMinor()) {
                        lastGood = map;
                    }
                    if (minor >= map.getMinor()) continue;
                    return lastGood;
                }
                return lastGood;
            }

            public static ProtocolMappings getLast(boolean remapped) {
                return Arrays.stream(ProtocolMappings.values()).filter(map -> map.isRemapped() == remapped).reduce((l, r) -> r).get();
            }

            static {
                try {
                    ProtocolMappings.fillAll();
                }
                catch (ReflectiveOperationException ex) {
                    logger.severe("Failed to fill up all datas for mappings.");
                    ex.printStackTrace();
                }
            }
        }
    }

    private static class PlayerData {
        final GlowingEntities instance;
        final Player player;
        final Map<Integer, GlowingData> glowingDatas;
        ChannelHandler packetsHandler;
        EnumSet<ChatColor> sentColors;

        PlayerData(GlowingEntities instance, Player player) {
            this.instance = instance;
            this.player = player;
            this.glowingDatas = new HashMap<Integer, GlowingData>();
        }
    }

    private static class GlowingData {
        final PlayerData player;
        final int entityID;
        final String teamID;
        ChatColor color;
        byte otherFlags;
        boolean enabled;

        GlowingData(PlayerData player, int entityID, String teamID, ChatColor color, byte otherFlags) {
            this.player = player;
            this.entityID = entityID;
            this.teamID = teamID;
            this.color = color;
            this.otherFlags = otherFlags;
            this.enabled = true;
        }
    }
}

