/*
 * Decompiled with CFR 0.152.
 */
package me.bunnky.slimevision.items.slimeeyes;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import me.bunnky.slimevision.items.slimeeyes.SlimeEye;
import me.bunnky.slimevision.utility.Utilities;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class SlimeEyeInverted
extends SlimeEye {
    public SlimeEyeInverted(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int radius, int cooldown) {
        super(itemGroup, item, recipeType, recipe, radius, cooldown);
    }

    @Override
    public String getTypeName() {
        return "Inverted Slime Eye";
    }

    @Override
    protected void checkBlocks(@NotNull Player p, boolean inverted) {
        UUID pUUID = p.getUniqueId();
        Set cached = (Set)this.cachedBlocks.get(pUUID);
        World w = p.getWorld();
        Vector loc = Utilities.getPlayerVector(p);
        int pX = loc.getBlockX();
        int pY = loc.getBlockY();
        int pZ = loc.getBlockZ();
        int minX = pX - this.r;
        int minY = Utilities.getClampedCoordinate(pY, -this.r, -64, 320);
        int minZ = pZ - this.r;
        int maxX = pX + this.r;
        int maxY = Utilities.getClampedCoordinate(pY, this.r, -64, 320);
        int maxZ = pZ + this.r;
        HashSet<Block> currBlocks = new HashSet<Block>();
        ChatColor currentColor = this.cIdx == 0 ? ChatColor.RED : cOpts[this.cIdx - 1];
        for (Block b : cached) {
            if (this.isInRange(b, minX, minY, minZ, maxX, maxY, maxZ) && Utilities.hasBlockStorage(b)) continue;
            this.updateGlowingBlock(b, p, currentColor, false);
        }
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    Block b = w.getBlockAt(x, y, z);
                    if (!b.getType().isAir()) continue;
                    if (cached.contains(b)) {
                        currBlocks.add(b);
                        this.updateGlowingBlock(b, p, currentColor, true);
                        continue;
                    }
                    if (!Utilities.hasBlockStorage(b)) continue;
                    cached.add(b);
                    currBlocks.add(b);
                    this.updateGlowingBlock(b, p, currentColor, true);
                }
            }
        }
        cached.retainAll(currBlocks);
        this.sendCountMessage(p, currBlocks.size(), true);
    }
}

