/*
 * Decompiled with CFR 0.152.
 */
package me.bunnky.slimevision.items.slimeeyes;

import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import me.bunnky.slimevision.SlimeVision;
import me.bunnky.slimevision.items.slimeeyes.SlimeEye;
import me.bunnky.slimevision.utility.Utilities;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class SlimeCleaner
extends SlimeEye {
    public SlimeCleaner(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe, 10, 0);
        Utilities.setGlow(item);
    }

    @Override
    protected void onRightClick(@NotNull PlayerRightClickEvent e) {
        e.cancel();
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player p = e.getPlayer();
        if (!p.isOp()) {
            return;
        }
        this.removeBlocksInRadius(p);
    }

    protected void removeBlocksInRadius(final Player p) {
        World w = p.getWorld();
        Vector loc = p.getLocation().toVector();
        int minX = loc.getBlockX() - 10;
        int minY = Math.max(loc.getBlockY() - 10, w.getMinHeight());
        int minZ = loc.getBlockZ() - 10;
        int maxX = loc.getBlockX() + 10;
        int maxY = Math.min(loc.getBlockY() + 10, w.getMaxHeight());
        int maxZ = loc.getBlockZ() + 10;
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    final Block b = w.getBlockAt(x, y, z);
                    if (!BlockStorage.hasBlockInfo((Block)b)) continue;
                    new BukkitRunnable(){

                        public void run() {
                            BlockBreakEvent e = new BlockBreakEvent(b, p);
                            Bukkit.getPluginManager().callEvent((Event)e);
                            if (!e.isCancelled()) {
                                BlockStorage.clearBlockInfo((Block)b);
                                b.setType(Material.AIR);
                            }
                        }
                    }.runTaskLater((Plugin)SlimeVision.getInstance(), 1L);
                }
            }
        }
    }

    @Override
    protected void checkBlocks(@NotNull Player p, boolean inverted) {
    }
}

