/*
 * Decompiled with CFR 0.152.
 */
package me.bunnky.slimevision.items.slimeeyes;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import me.bunnky.slimevision.items.slimeeyes.SlimeEye;
import me.bunnky.slimevision.utility.Utilities;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class SlimeEyeNetworks
extends SlimeEye {
    public SlimeEyeNetworks(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int radius, int cooldown) {
        super(itemGroup, item, recipeType, recipe, radius, cooldown);
        Utilities.setGlow(item);
    }

    @Override
    protected void startHighlight(@NotNull Player p) {
        super.startHighlight(p);
        this.checkBlocks(p, false);
    }

    @Override
    protected void checkBlocks(@NotNull Player p, boolean inverted) {
        UUID pUUID = p.getUniqueId();
        Set cached = (Set)this.cachedBlocks.get(pUUID);
        World w = p.getWorld();
        Vector loc = Utilities.getPlayerVector(p);
        int pX = loc.getBlockX();
        int pY = loc.getBlockY();
        int pZ = loc.getBlockZ();
        int minX = pX - this.r;
        int minY = Utilities.getClampedCoordinate(pY, -this.r, -64, 320);
        int minZ = pZ - this.r;
        int maxX = pX + this.r;
        int maxY = Utilities.getClampedCoordinate(pY, this.r, -64, 320);
        int maxZ = pZ + this.r;
        HashSet<Block> currBlocks = new HashSet<Block>();
        ChatColor currentColor = this.cIdx == 0 ? ChatColor.DARK_PURPLE : cOpts[this.cIdx - 1];
        for (Block b : cached) {
            if (super.isInRange(b, minX, minY, minZ, maxX, maxY, maxZ)) continue;
            this.updateGlowingBlock(b, p, currentColor, false);
        }
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    Block b = w.getBlockAt(x, y, z);
                    if (Utilities.isAirOrLiquid(b) || !cached.contains(b) && (!Utilities.hasBlockStorage(b) || !"Networks".equals(BlockStorage.check((Block)b).getAddon().getName()))) continue;
                    cached.add(b);
                    currBlocks.add(b);
                    this.updateGlowingBlock(b, p, currentColor, true);
                    if (cached.contains(b)) continue;
                    cached.add(b);
                }
            }
        }
        cached.retainAll(currBlocks);
        this.sendCountMessage(p, cached.size(), false);
    }

    @Override
    protected void sendCountMessage(Player p, int total, boolean inverted) {
        UUID pUUID = p.getUniqueId();
        int currentMsgCd = this.msgCds.getOrDefault(pUUID, 0);
        int currentPrevCount = this.prev.getOrDefault(pUUID, 0);
        if (currentMsgCd > 0 && total == currentPrevCount) {
            this.msgCds.put(pUUID, currentMsgCd - 1);
            return;
        }
        StringBuilder message = new StringBuilder();
        message.append("\u00a7nIn Range:\n");
        message.append("\u00a75Networks: \u00a7e").append(total).append("\n");
        message.append("\u00a7f\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\n");
        p.sendMessage(message.toString());
        this.msgCds.put(pUUID, 5);
        this.prev.put(pUUID, total);
    }
}

