/*
 * Decompiled with CFR 0.152.
 */
package me.bunnky.slimevision.items.slimeeyes;

import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.bunnky.slimevision.SlimeVision;
import me.bunnky.slimevision.items.slimeeyes.SlimeEye;
import me.bunnky.slimevision.utility.Utilities;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class SlimeEyeGod
extends SlimeEye {
    private final Map<UUID, Boolean> toggledOn = new HashMap<UUID, Boolean>();
    private final Map<UUID, Boolean> invisibleToggledOn = new HashMap<UUID, Boolean>();
    private final Map<UUID, Long> lastMessageSentMap = new HashMap<UUID, Long>();
    private final Map<UUID, Integer> lastNetworkCountMap = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> lastTotalCountMap = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> lastAirCountMap = new HashMap<UUID, Integer>();
    private final Map<UUID, BukkitRunnable> activeTasks = new HashMap<UUID, BukkitRunnable>();

    public SlimeEyeGod(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int radius) {
        super(itemGroup, item, recipeType, recipe, radius, 0);
        this.hidden = true;
        Utilities.setGlow(item);
    }

    @Override
    @Nonnull
    public ItemUseHandler getItemHandler() {
        return this::onRightClick;
    }

    @EventHandler
    protected void onPlayerInteract(PlayerInteractEvent e) {
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (!Utilities.isSlimeEyeGod(e.getItem())) {
            return;
        }
        if (e.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        final Block b = e.getClickedBlock();
        if (b == null) {
            return;
        }
        e.setCancelled(true);
        final Player p = e.getPlayer();
        if (!p.isOp()) {
            return;
        }
        if (p.isSneaking()) {
            this.placeBlock(b, e.getBlockFace());
        } else {
            new BukkitRunnable(){

                public void run() {
                    BlockBreakEvent e = new BlockBreakEvent(b, p);
                    Bukkit.getPluginManager().callEvent((Event)e);
                    if (e.isCancelled()) {
                        return;
                    }
                    BlockStorage.clearBlockInfo((Block)b);
                    b.setType(Material.AIR);
                }
            }.runTaskLater((Plugin)SlimeVision.getInstance(), 1L);
        }
    }

    private void placeBlock(Block b, BlockFace f) {
        Utilities.placeBlock(b, f, Material.TARGET);
    }

    @Override
    protected void onRightClick(@NotNull PlayerRightClickEvent e) {
        boolean currentState;
        e.cancel();
        Player p = e.getPlayer();
        if (!p.isOp()) {
            return;
        }
        UUID pUUID = p.getUniqueId();
        this.toggledOn.putIfAbsent(pUUID, false);
        this.invisibleToggledOn.putIfAbsent(pUUID, false);
        this.cachedBlocks.putIfAbsent(pUUID, new HashSet());
        Set playerCachedBlocks = (Set)this.cachedBlocks.get(pUUID);
        if (e.getHand() == EquipmentSlot.OFF_HAND) {
            if (!playerCachedBlocks.isEmpty()) {
                playerCachedBlocks.clear();
            }
            this.checkInvisibleBlocks(p);
            if (!playerCachedBlocks.isEmpty()) {
                this.placeBlocksAtInvisibleLocations(pUUID);
                p.sendMessage("\u00a76Blocks placed at invisible machine locations.");
            } else {
                p.sendMessage("\u00a7cNo invisible machines to place blocks at.");
            }
            return;
        }
        boolean isInvertedGazeOn = this.invisibleToggledOn.getOrDefault(pUUID, false);
        if (p.isSneaking()) {
            if (isInvertedGazeOn) {
                this.cancelHighlightTask(pUUID);
                playerCachedBlocks.clear();
                this.invisibleToggledOn.put(pUUID, false);
                p.sendMessage("\u00a7cInverted Slime Gaze disabled.");
            } else {
                this.cancelHighlightTask(pUUID);
                playerCachedBlocks.clear();
                this.toggledOn.put(pUUID, false);
                this.invisibleToggledOn.put(pUUID, true);
                this.startHighlightTask(p, true);
                p.sendMessage("\u00a76Inverted Slime Gaze enabled.");
            }
            return;
        }
        if (isInvertedGazeOn) {
            this.cancelHighlightTask(pUUID);
            playerCachedBlocks.clear();
            this.invisibleToggledOn.put(pUUID, false);
            p.sendMessage("\u00a7cInverted Slime Gaze disabled.");
        }
        this.toggledOn.put(pUUID, !(currentState = this.toggledOn.getOrDefault(pUUID, false).booleanValue()));
        if (this.toggledOn.get(pUUID).booleanValue()) {
            playerCachedBlocks.clear();
            this.startHighlightTask(p, false);
            p.sendMessage("\u00a76Slime Gaze enabled.");
        } else {
            this.cancelHighlightTask(pUUID);
            playerCachedBlocks.clear();
            p.sendMessage("\u00a7cSlime Gaze disabled.");
        }
    }

    protected void startHighlightTask(final @NotNull Player p, final boolean isInvisible) {
        UUID pUUID = p.getUniqueId();
        boolean currentToggle = isInvisible ? this.invisibleToggledOn.getOrDefault(pUUID, false) : this.toggledOn.getOrDefault(pUUID, false);
        if (this.activeTasks.containsKey(pUUID) || !currentToggle) {
            return;
        }
        BukkitRunnable task = new BukkitRunnable(){

            public void run() {
                if (isInvisible) {
                    SlimeEyeGod.this.checkInvisibleBlocks(p);
                } else {
                    SlimeEyeGod.this.checkBlocks(p);
                }
            }
        };
        task.runTaskTimer((Plugin)SlimeVision.getInstance(), 0L, 20L);
        this.activeTasks.put(pUUID, task);
    }

    protected void cancelHighlightTask(UUID pUUID) {
        Set blocksToUnset;
        Player p;
        BukkitRunnable task = this.activeTasks.remove(pUUID);
        if (task != null) {
            task.cancel();
        }
        if ((p = Bukkit.getServer().getPlayer(pUUID)) != null && (blocksToUnset = (Set)this.cachedBlocks.get(pUUID)) != null) {
            for (Block b : blocksToUnset) {
                this.updateGlowingBlock(b, p, null, false);
            }
        }
        this.cachedBlocks.remove(pUUID, this.cachedBlocks);
    }

    protected void checkInvisibleBlocks(@NotNull Player p) {
        this.checkBlocks(p, true);
    }

    protected void checkBlocks(@NotNull Player p) {
        this.checkBlocks(p, false);
    }

    private void placeBlocksAtInvisibleLocations(UUID pUUID) {
        for (Block iBlock : (Set)this.cachedBlocks.get(pUUID)) {
            if (!Utilities.isAirOrLiquid(iBlock)) continue;
            Utilities.placeBlock(iBlock, BlockFace.SELF, Material.TARGET);
        }
    }

    @Override
    protected void checkBlocks(@NotNull Player p, boolean checkInvisible) {
        boolean newMachinesFound;
        World w = p.getWorld();
        Vector loc = Utilities.getPlayerVector(p);
        int pX = loc.getBlockX();
        int pY = loc.getBlockY();
        int pZ = loc.getBlockZ();
        int minX = pX - this.r;
        int minY = Utilities.getClampedCoordinate(pY, -this.r, -64, 320);
        int minZ = pZ - this.r;
        int maxX = pX + this.r;
        int maxY = Utilities.getClampedCoordinate(pY, this.r, -64, 320);
        int maxZ = pZ + this.r;
        HashSet<Block> networkBlocks = new HashSet<Block>();
        HashSet<Block> airBlocks = new HashSet<Block>();
        ArrayList<String> nullMachines = new ArrayList<String>();
        UUID pUUID = p.getUniqueId();
        Set playerCachedBlocks = this.cachedBlocks.computeIfAbsent(pUUID, k -> new HashSet());
        Iterator iterator = playerCachedBlocks.iterator();
        while (iterator.hasNext()) {
            Block b = (Block)iterator.next();
            if (this.isInRange(b, minX, minY, minZ, maxX, maxY, maxZ)) continue;
            this.updateGlowingBlock(b, p, null, false);
            iterator.remove();
        }
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    Block b = w.getBlockAt(x, y, z);
                    if (!Utilities.hasBlockStorage(b)) continue;
                    SlimefunItem sfItem = BlockStorage.check((Block)b);
                    if (sfItem != null) {
                        if (checkInvisible) {
                            if (!Utilities.isAirOrLiquid(b)) continue;
                            airBlocks.add(b);
                            playerCachedBlocks.add(b);
                            this.updateGlowingBlock(b, p, ChatColor.RED, true);
                            continue;
                        }
                        if ("Networks".equals(sfItem.getAddon().getName()) && !Utilities.isAirOrLiquid(b)) {
                            networkBlocks.add(b);
                            playerCachedBlocks.add(b);
                            this.updateGlowingBlock(b, p, ChatColor.LIGHT_PURPLE, true);
                            continue;
                        }
                        if (Utilities.isAirOrLiquid(b)) {
                            airBlocks.add(b);
                            playerCachedBlocks.add(b);
                            this.updateGlowingBlock(b, p, ChatColor.RED, true);
                            continue;
                        }
                        playerCachedBlocks.add(b);
                        this.updateGlowingBlock(b, p, ChatColor.GREEN, true);
                        continue;
                    }
                    playerCachedBlocks.add(b);
                    this.updateGlowingBlock(b, p, ChatColor.BLACK, true);
                    nullMachines.add(b.getX() + ", " + b.getY() + ", " + b.getZ());
                    BlockStorage.clearBlockInfo((Block)b);
                }
            }
        }
        long currentTime = System.currentTimeMillis();
        long lastSent = this.lastMessageSentMap.getOrDefault(pUUID, 0L);
        int lastNetworkCount = this.lastNetworkCountMap.getOrDefault(pUUID, 0);
        int lastTotalCount = this.lastTotalCountMap.getOrDefault(pUUID, 0);
        int lastAirCount = this.lastAirCountMap.getOrDefault(pUUID, 0);
        boolean bl = newMachinesFound = networkBlocks.size() != lastNetworkCount || playerCachedBlocks.size() != lastTotalCount || airBlocks.size() != lastAirCount;
        if (currentTime - lastSent >= 5000L || newMachinesFound) {
            this.sendCountMessage(p, networkBlocks.size(), playerCachedBlocks.size(), airBlocks.size(), nullMachines);
            this.lastMessageSentMap.put(pUUID, currentTime);
            this.lastNetworkCountMap.put(pUUID, networkBlocks.size());
            this.lastTotalCountMap.put(pUUID, playerCachedBlocks.size());
            this.lastAirCountMap.put(pUUID, airBlocks.size());
        }
    }

    private void sendCountMessage(Player p, int networkCount, int totalCount, int airCount, List<String> nullMachines) {
        UUID pUUID = p.getUniqueId();
        boolean isInvisibleToggled = this.invisibleToggledOn.getOrDefault(pUUID, false);
        StringBuilder m = new StringBuilder();
        m.append("\u00a7nIn Range:\n");
        if (isInvisibleToggled) {
            m.append("\u00a77Invisible: \u00a7e").append(airCount).append("\n");
        } else {
            m.append("\u00a75Networks: \u00a7e").append(networkCount).append("\n");
            m.append("\u00a77Invisible: \u00a7e").append(airCount).append("\n");
            m.append("\u00a7aValid: \u00a7e").append(totalCount).append("\n");
            if (!nullMachines.isEmpty()) {
                m.append("\u00a7cNull:\n");
                for (String machine : nullMachines) {
                    m.append("\u00a77").append(machine).append("\n");
                }
            }
        }
        m.append("\u00a7f\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\u2508\n");
        p.sendMessage(m.toString());
    }

    @EventHandler
    protected void onItemHeld(@NotNull PlayerItemHeldEvent e) {
        Player p = e.getPlayer();
        ItemStack newItem = p.getInventory().getItem(e.getNewSlot());
        UUID pUUID = p.getUniqueId();
        if (Utilities.isSlimeEyeGod(p.getInventory().getItemInMainHand()) && this.activeTasks.containsKey(pUUID) && !Utilities.isSlimeEyeGod(newItem)) {
            this.cancelHighlightTask(pUUID);
            this.cachedBlocks.remove(pUUID, this.cachedBlocks);
            this.toggledOn.put(pUUID, false);
            this.invisibleToggledOn.put(pUUID, false);
            p.sendMessage("\u00a7cSlime Gaze disabled.");
        }
    }
}

