/*
 * Decompiled with CFR 0.152.
 */
package me.bunnky.slimevision;

import fr.skytasul.glowingentities.GlowingBlocks;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.BlobBuildUpdater;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.annotation.Nonnull;
import me.bunnky.slimevision.bukkit.Metrics;
import me.bunnky.slimevision.charts.AdvancedPie;
import me.bunnky.slimevision.items.slimeeyes.SlimeEye;
import me.bunnky.slimevision.slimefun.Setup;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SlimeVision
extends JavaPlugin
implements SlimefunAddon {
    private static SlimeVision instance;
    private final String username;
    private final String repo;
    private GlowingBlocks glowingBlocks;

    public SlimeVision() {
        this.username = "Bunnky";
        this.repo = "SlimeVision";
    }

    public void onEnable() {
        instance = this;
        this.getLogger().info("    .-=-.    .-=-.     ");
        this.getLogger().info("   ( 0   )  ( 0   )    ");
        this.getLogger().info("    `-=-'    `-=-'     ");
        this.getLogger().info("     Slime Vision      ");
        this.getLogger().info("       by Bunnky       ");
        this.saveDefaultConfig();
        this.tryUpdate();
        this.glowingBlocks = new GlowingBlocks((Plugin)this);
        Setup.setup();
        this.setupMetrics();
    }

    public void setupMetrics() {
        Metrics metrics = new Metrics(this, 23251);
        AdvancedPie playersChart = new AdvancedPie("slimeeye_users", () -> {
            HashMap vmap = new HashMap();
            SlimeEye.getUsers().forEach(users -> vmap.put(users, 1));
            return vmap;
        });
        AdvancedPie eyeChart = new AdvancedPie("slimeeye_types", SlimeEye::getSlimeEyeUsage);
        metrics.addCustomChart(playersChart);
        metrics.addCustomChart(eyeChart);
    }

    public void tryUpdate() {
        if (this.getConfig().getBoolean("options.auto-update", true) && this.getDescription().getVersion().startsWith("Dev - ")) {
            new BlobBuildUpdater((Plugin)this, this.getFile(), "SlimeVision", "Dev").start();
        }
    }

    public static void consoleMsg(@Nonnull String string) {
        instance.getLogger().info(string);
    }

    public static SlimeVision getInstance() {
        return instance;
    }

    public GlowingBlocks getGlowingBlocks() {
        return this.glowingBlocks;
    }

    public void onDisable() {
        if (this.glowingBlocks != null) {
            this.glowingBlocks.disable();
        }
    }

    public String getBugTrackerURL() {
        return MessageFormat.format("https://github.com/{0}/{1}/issues", this.username, this.repo);
    }

    @Nonnull
    public JavaPlugin getJavaPlugin() {
        return this;
    }
}

