/*
 * Decompiled with CFR 0.152.
 */
package io.github.bakedlibs.dough.skins.nms;

import com.mojang.authlib.GameProfile;
import io.github.bakedlibs.dough.reflection.ReflectionUtils;
import io.github.bakedlibs.dough.skins.nms.PlayerHeadAdapter;
import io.github.bakedlibs.dough.versions.UnknownServerVersionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.block.Block;

class PlayerHeadAdapter17
implements PlayerHeadAdapter {
    private final Constructor<?> newPosition;
    private final Method getHandle;
    private final Method getTileEntity;
    private final Method setGameProfile = ReflectionUtils.getNetMinecraftClass("world.level.block.entity.TileEntitySkull").getMethod("setGameProfile", GameProfile.class);

    PlayerHeadAdapter17() throws NoSuchMethodException, SecurityException, ClassNotFoundException, UnknownServerVersionException {
        this.getHandle = ReflectionUtils.getOBCClass("CraftWorld").getMethod("getHandle", new Class[0]);
        Class<?> blockPosition = ReflectionUtils.getNetMinecraftClass("core.BlockPosition");
        this.newPosition = ReflectionUtils.getConstructor(blockPosition, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        this.getTileEntity = ReflectionUtils.getNMSClass("level.WorldServer").getMethod("getTileEntity", blockPosition);
    }

    @ParametersAreNonnullByDefault
    @Nullable
    private Object getTileEntity(Block block) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Object world = this.getHandle.invoke((Object)block.getWorld(), new Object[0]);
        Object position = this.newPosition.newInstance(block.getX(), block.getY(), block.getZ());
        return this.getTileEntity.invoke(world, position);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void setGameProfile(Block block, GameProfile profile, boolean sendBlockUpdate) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Object tileEntity = this.getTileEntity(block);
        if (tileEntity == null) {
            return;
        }
        this.setGameProfile.invoke(tileEntity, profile);
        if (sendBlockUpdate) {
            block.getState().update(true, false);
        }
    }
}

