/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.common;

import java.util.HashMap;
import java.util.Map;

public final class RateLimit<K> {
    private final long limitTime;
    private final int limitVisits;
    private final Map<K, Long> timeMap = new HashMap<K, Long>();
    private final Map<K, Integer> visitMap = new HashMap<K, Integer>();

    public RateLimit(long time, int visits) {
        this.limitTime = time;
        this.limitVisits = visits;
    }

    public int getLimit() {
        return this.limitVisits;
    }

    public int getUsed(K key) {
        Long time = this.timeMap.get(key);
        Integer visits = this.visitMap.get(key);
        if (time == null || visits == null) {
            return 0;
        }
        if (System.nanoTime() - time >= this.limitTime) {
            return 0;
        }
        return visits;
    }

    public int getRemaining(K key) {
        return this.getLimit() - this.getUsed(key);
    }

    public boolean add(K key, int visits) {
        Long time = this.timeMap.get(key);
        Integer visited = this.visitMap.get(key);
        if (time == null || visited == null) {
            this.reset(key);
            this.timeMap.put(key, System.nanoTime());
            this.visitMap.put(key, visits);
            return true;
        }
        if (this.getRemaining(key) < visits) {
            return false;
        }
        this.visitMap.put(key, visited + visits);
        return true;
    }

    public boolean add(K key) {
        return this.add(key, 1);
    }

    public void reset(K key) {
        this.timeMap.remove(key);
        this.visitMap.remove(key);
    }
}

