/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.glowingentities;

import fr.skytasul.glowingentities.GlowingEntities;
import io.papermc.paper.event.packet.PlayerChunkLoadEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class GlowingBlocks
implements Listener {
    @NotNull
    private final GlowingEntities entities;
    private Map<Player, PlayerData> glowing;
    private boolean enabled = false;

    public GlowingBlocks(@NotNull Plugin plugin) {
        this.testForPaper();
        this.entities = new GlowingEntities(plugin);
        this.enable();
    }

    public void enable() {
        if (this.enabled) {
            throw new IllegalStateException("The Glowing Blocks API has already been enabled.");
        }
        this.entities.plugin.getServer().getPluginManager().registerEvents((Listener)this, this.entities.plugin);
        if (!this.entities.enabled) {
            this.entities.enable();
        }
        this.glowing = new HashMap<Player, PlayerData>();
        this.enabled = true;
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        HandlerList.unregisterAll((Listener)this);
        this.glowing.values().forEach(playerData -> playerData.datas.values().forEach(glowingData -> {
            try {
                glowingData.remove();
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        }));
        this.entities.disable();
        this.glowing = null;
        this.enabled = false;
    }

    private void ensureEnabled() {
        if (!this.enabled) {
            throw new IllegalStateException("The Glowing Blocks API is not enabled.");
        }
    }

    private void testForPaper() {
        try {
            Class.forName("io.papermc.paper.event.packet.PlayerChunkLoadEvent");
        }
        catch (ClassNotFoundException ex) {
            throw new UnsupportedOperationException("The GlowingBlocks util can only be used on a Paper server.");
        }
    }

    public void setGlowing(@NotNull Block block, @NotNull Player receiver, @NotNull ChatColor color) throws ReflectiveOperationException {
        this.setGlowing(block.getLocation(), receiver, color);
    }

    public void setGlowing(@NotNull Location block, @NotNull Player receiver, @NotNull ChatColor color) throws ReflectiveOperationException {
        this.ensureEnabled();
        block = this.normalizeLocation(block);
        if (!color.isColor()) {
            throw new IllegalArgumentException("ChatColor must be a color format");
        }
        PlayerData playerData = this.glowing.computeIfAbsent(Objects.requireNonNull(receiver), PlayerData::new);
        GlowingBlockData blockData = playerData.datas.get(block);
        if (blockData == null) {
            blockData = new GlowingBlockData(receiver, block, color);
            playerData.datas.put(block, blockData);
            if (this.canSee(receiver, block)) {
                blockData.spawn();
            }
        } else {
            blockData.setColor(color);
        }
    }

    public void unsetGlowing(@NotNull Block block, @NotNull Player receiver) throws ReflectiveOperationException {
        this.unsetGlowing(block.getLocation(), receiver);
    }

    public void unsetGlowing(@NotNull Location block, @NotNull Player receiver) throws ReflectiveOperationException {
        this.ensureEnabled();
        block = this.normalizeLocation(block);
        PlayerData playerData = this.glowing.get(receiver);
        if (playerData == null) {
            return;
        }
        GlowingBlockData blockData = playerData.datas.remove(block);
        if (blockData == null) {
            return;
        }
        blockData.remove();
        if (playerData.datas.isEmpty()) {
            this.glowing.remove(receiver);
        }
    }

    @NotNull
    private Location normalizeLocation(@NotNull Location location) {
        location.checkFinite();
        return new Location(location.getWorld(), (double)location.getBlockX(), (double)location.getBlockY(), (double)location.getBlockZ());
    }

    private boolean canSee(Player player, Location location) {
        int deltaChunkZ;
        int viewDistance = Math.min(player.getViewDistance(), Bukkit.getViewDistance());
        int deltaChunkX = (player.getLocation().getBlockX() >> 4) - (location.getBlockX() >> 4);
        int chunkDistanceSquared = deltaChunkX * deltaChunkX + (deltaChunkZ = (player.getLocation().getBlockZ() >> 4) - (location.getBlockZ() >> 4)) * deltaChunkZ;
        return chunkDistanceSquared <= viewDistance * viewDistance;
    }

    @EventHandler
    public void onPlayerChunkLoad(PlayerChunkLoadEvent event) {
        PlayerData playerData = this.glowing.get(event.getPlayer());
        if (playerData == null) {
            return;
        }
        playerData.datas.forEach((location, blockData) -> {
            if (Objects.equals(location.getWorld(), event.getWorld()) && location.getBlockX() >> 4 == event.getChunk().getX() && location.getBlockZ() >> 4 == event.getChunk().getZ()) {
                try {
                    blockData.spawn();
                }
                catch (ReflectiveOperationException ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    private record PlayerData(@NotNull Player player, @NotNull Map<Location, GlowingBlockData> datas) {
        public PlayerData(@NotNull Player player) {
            this(player, new HashMap<Location, GlowingBlockData>());
        }
    }

    private class GlowingBlockData {
        private static final byte FLAGS = 32;
        private static final AtomicInteger ENTITY_ID_COUNTER = new AtomicInteger(ThreadLocalRandom.current().nextInt(1000000, 2000000000));
        @NotNull
        private final Player player;
        @NotNull
        private final Location location;
        @NotNull
        private ChatColor color;
        private int entityId;
        private UUID entityUuid;

        public GlowingBlockData(@NotNull Player player, @NotNull Location location, ChatColor color) {
            this.player = player;
            this.location = location;
            this.color = color;
        }

        public void setColor(@NotNull ChatColor color) throws ReflectiveOperationException {
            this.color = color;
            if (this.entityUuid != null) {
                GlowingBlocks.this.entities.setGlowing(this.entityId, this.entityUuid.toString(), this.player, color, (byte)32);
            }
        }

        public void spawn() throws ReflectiveOperationException {
            this.init();
            GlowingEntities.Packets.createEntity(this.player, this.entityId, this.entityUuid, GlowingEntities.Packets.shulkerEntityType, this.location);
            GlowingEntities.Packets.setMetadata(this.player, this.entityId, (byte)32, false);
        }

        public void remove() throws ReflectiveOperationException {
            if (this.entityUuid == null) {
                return;
            }
            GlowingEntities.Packets.removeEntities(this.player, this.entityId);
            GlowingBlocks.this.entities.unsetGlowing(this.entityId, this.player);
        }

        private void init() throws ReflectiveOperationException {
            if (this.entityUuid == null) {
                this.entityId = ENTITY_ID_COUNTER.getAndIncrement();
                this.entityUuid = UUID.randomUUID();
                this.setColor(this.color);
            }
        }
    }
}

