/*
 * Decompiled with CFR 0.152.
 */
package io.github.bakedlibs.dough.skins;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.github.bakedlibs.dough.reflection.ReflectionUtils;
import io.github.bakedlibs.dough.versions.MinecraftVersion;
import io.github.bakedlibs.dough.versions.UnknownServerVersionException;
import java.net.URL;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public final class CustomGameProfile
extends GameProfile {
    private static final String PLAYER_NAME = "CS-CoreLib";
    private static final String PROPERTY_KEY = "textures";
    private final URL skinUrl;
    private final String texture;

    CustomGameProfile(@Nonnull UUID uuid, @Nullable String texture, @Nonnull URL url) {
        super(uuid, PLAYER_NAME);
        this.skinUrl = url;
        this.texture = texture;
        if (texture != null) {
            this.getProperties().put((Object)PROPERTY_KEY, (Object)new Property(PROPERTY_KEY, texture));
        }
    }

    void apply(@Nonnull SkullMeta meta) throws NoSuchFieldException, IllegalAccessException, UnknownServerVersionException {
        if (MinecraftVersion.get().isAtLeast(MinecraftVersion.parse("1.20"))) {
            PlayerProfile playerProfile = Bukkit.createPlayerProfile((UUID)this.getId(), (String)PLAYER_NAME);
            PlayerTextures playerTextures = playerProfile.getTextures();
            playerTextures.setSkin(this.skinUrl);
            playerProfile.setTextures(playerTextures);
            meta.setOwnerProfile(playerProfile);
        } else {
            ReflectionUtils.setFieldValue(meta, "profile", (Object)this);
            meta.setOwningPlayer(meta.getOwningPlayer());
            ReflectionUtils.setFieldValue(meta, "profile", (Object)this);
        }
    }

    @Nullable
    public String getBase64Texture() {
        return this.texture;
    }
}

