/*
 * Decompiled with CFR 0.152.
 */
package io.github.bakedlibs.dough.items;

import io.github.bakedlibs.dough.items.ItemStackEditor;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@ParametersAreNonnullByDefault
public final class CustomItemStack {
    private CustomItemStack() {
        throw new IllegalStateException("Cannot instantiate CustomItemStack");
    }

    public static ItemStack create(ItemStack itemStack, Consumer<ItemMeta> metaConsumer) {
        return new ItemStackEditor(itemStack).andMetaConsumer(metaConsumer).create();
    }

    public static ItemStack create(Material material, Consumer<ItemMeta> metaConsumer) {
        return new ItemStackEditor(material).andMetaConsumer(metaConsumer).create();
    }

    public static ItemStack create(ItemStack item, @Nullable String name, String ... lore) {
        return new ItemStackEditor(item).setDisplayName(name).setLore(lore).create();
    }

    public static ItemStack create(Material material, @Nullable String name, String ... lore) {
        return CustomItemStack.create(new ItemStack(material), name, lore);
    }

    public static ItemStack create(Material type, @Nullable String name, List<String> lore) {
        return CustomItemStack.create(new ItemStack(type), name, (String[])lore.toArray(String[]::new));
    }

    public static ItemStack create(ItemStack item, List<String> list) {
        return CustomItemStack.create(new ItemStack(item), list.get(0), (String[])list.subList(1, list.size()).toArray(String[]::new));
    }

    public static ItemStack create(Material type, List<String> list) {
        return CustomItemStack.create(new ItemStack(type), list);
    }

    public static ItemStack create(ItemStack item, int amount) {
        return new ItemStackEditor(item).setAmount(amount).create();
    }

    @Deprecated(forRemoval=true)
    public static ItemStack create(ItemStack itemStack, Material type) {
        return new ItemStackEditor(itemStack).andStackConsumer(item -> item.setType(type)).create();
    }
}

