/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.utils;

import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public final class EntityUtils {
    private static final NamespacedKey IGNORE_DAMAGE_KEY = new NamespacedKey((Plugin)Slimefun.instance(), "ignore_damage");

    private EntityUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void push(@Nonnull LivingEntity pushed, @Nonnull Location loc, double force) {
        if (pushed.hasMetadata("NPC")) {
            return;
        }
        Vector v = pushed.getLocation().toVector().subtract(loc.toVector()).normalize().multiply(force);
        v.add(new Vector(0.0, force + 1.0, 0.0));
        pushed.setVelocity(v);
    }

    public static void increaseEffect(PotionEffectType potionEffectType, Map<PotionEffectType, Integer> potionEffects) {
        EntityUtils.increaseEffect(potionEffectType, potionEffects, 1);
    }

    public static void increaseEffect(PotionEffectType potionEffectType, @Nonnull Map<PotionEffectType, Integer> potionEffects, int amount) {
        if (potionEffects.containsKey(potionEffectType)) {
            potionEffects.put(potionEffectType, potionEffects.get(potionEffectType) + amount);
        } else {
            potionEffects.put(potionEffectType, amount);
        }
    }

    public static boolean isTrainingDummy(@Nonnull Entity e) {
        return e.getCustomName() != null && e.getCustomName().equals("Dummy");
    }

    public static boolean shouldIgnoreDamage(Entity e) {
        return PersistentDataAPI.getBoolean((PersistentDataHolder)e, (NamespacedKey)IGNORE_DAMAGE_KEY);
    }

    public static double getFacing(@Nonnull Player p, @Nonnull Entity e) {
        Vector pd = p.getLocation().getDirection();
        Vector ed = e.getLocation().getDirection();
        double x = pd.getX() * ed.getZ() - pd.getZ() * ed.getX();
        double z = pd.getX() * ed.getX() + pd.getZ() * ed.getZ();
        double a = Math.atan2(x, z);
        return a * 180.0 / Math.PI;
    }

    public static boolean isFacingAway(Player p, Entity e) {
        return EntityUtils.isFacingAway(p, e, null);
    }

    public static boolean isFacingAway(Player p, Entity e, @Nullable Integer tolerance) {
        double d = EntityUtils.getFacing(p, e);
        Integer val = tolerance == null ? Integer.valueOf(30) : tolerance;
        return d <= (double)val.intValue() && d >= (double)(-val.intValue());
    }

    public static void makeBreed(@Nonnull Animals a) {
        if (a.isAdult() && !a.isLoveMode()) {
            a.setBreed(true);
            a.setLoveModeTicks(400);
            a.getWorld().spawnParticle(Particle.HEART, a.getLocation(), 4, 0.5, 0.5, 0.5);
        }
    }

    @Nonnull
    public static <T> List<T> getNearbyEntitiesByType(@Nonnull Class<?> clazz, @Nonnull Entity e, double x, double y, double z) {
        return EntityUtils.getNearbyEntitiesByType(clazz, e.getLocation(), x, y, z);
    }

    @Nonnull
    public static <T> List<T> getNearbyEntitiesByType(@Nonnull Class<?> clazz, @Nonnull Block b, double x, double y, double z) {
        return EntityUtils.getNearbyEntitiesByType(clazz, b.getLocation(), x, y, z);
    }

    @Nonnull
    public static <T> List<T> getNearbyEntitiesByType(@Nonnull Class<?> clazz, @Nonnull Location l, double x, double y, double z) {
        World world = l.getWorld();
        return (List)world.getNearbyEntities(l, x, y, z, clazz::isInstance);
    }

    @Nullable
    public static Entity getEntityLookedAtByEntity(LivingEntity lookingEntity) {
        return EntityUtils.getEntityLookedAtByEntityByType(lookingEntity, Entity.class);
    }

    @Nullable
    public static <T extends Entity> T getEntityLookedAtByEntityByType(@Nonnull LivingEntity lookingEntity, Class<? extends Entity> entityType) {
        Vector fromLookDir = lookingEntity.getEyeLocation().getDirection();
        Vector fromEyeLoc = lookingEntity.getEyeLocation().toVector();
        List<Entity> entityList = EntityUtils.getNearbyEntitiesByType(entityType, (Entity)lookingEntity, 15.0, 15.0, 15.0);
        for (Entity e : entityList) {
            Vector entityLoc;
            Vector pEntVec;
            float angle;
            if (!lookingEntity.hasLineOfSight(e) || !((angle = fromLookDir.angle(pEntVec = (entityLoc = e.getLocation().toVector()).subtract(fromEyeLoc))) < 0.2f)) continue;
            return (T)e;
        }
        return null;
    }
}

