/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.utils;

import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.TileState;
import org.bukkit.block.data.AnaloguePowerable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Lightable;
import org.bukkit.block.data.Powerable;
import org.bukkit.entity.Player;

public final class BlockUtils {
    private static final Map<Location, Boolean> STATE_MAP = new HashMap<Location, Boolean>();

    private BlockUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean isValidBreakEvent(Block block, Player player) {
        return !BlockUtils.isPlaced(block) && !BlockStorage.hasBlockInfo((Block)block) && !(block.getState() instanceof TileState) && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, block, Interaction.BREAK_BLOCK);
    }

    public static boolean isPlaced(Block block) {
        return STATE_MAP.getOrDefault(block.getLocation(), false);
    }

    public static BlockFace getTargetedBlockFace(Player player) {
        List lastTwoTargetBlocks = player.getLastTwoTargetBlocks(null, 100);
        if (lastTwoTargetBlocks.size() != 2 || !((Block)lastTwoTargetBlocks.get(1)).getType().isOccluding()) {
            return null;
        }
        Block targetBlock = (Block)lastTwoTargetBlocks.get(1);
        Block adjacentBlock = (Block)lastTwoTargetBlocks.get(0);
        return targetBlock.getFace(adjacentBlock);
    }

    public static void fakePower(Block block) {
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Powerable) {
            ((Powerable)blockData).setPowered(true);
        } else if (blockData instanceof AnaloguePowerable) {
            ((AnaloguePowerable)blockData).setPower(15);
        } else if (blockData instanceof Lightable) {
            ((Lightable)blockData).setLit(true);
        }
        block.setBlockData(blockData);
    }

    public static void fakeUnPower(Block block) {
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Powerable) {
            ((Powerable)blockData).setPowered(false);
        } else if (blockData instanceof AnaloguePowerable) {
            ((AnaloguePowerable)blockData).setPower(0);
        } else if (blockData instanceof Lightable) {
            ((Lightable)blockData).setLit(false);
        }
        block.setBlockData(blockData);
    }

    public static Map<Location, Boolean> getStateMap() {
        return STATE_MAP;
    }
}

