/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.items.workstations.repairbench;

import io.github.sefiraat.slimetinker.infinitylib.machines.MenuBlock;
import io.github.sefiraat.slimetinker.items.templates.RepairkitTemplate;
import io.github.sefiraat.slimetinker.utils.GUIItems;
import io.github.sefiraat.slimetinker.utils.ItemUtils;
import io.github.sefiraat.slimetinker.utils.ThemeUtils;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class RepairBench
extends MenuBlock {
    protected static final int CRAFT_BUTTON = 14;
    protected static final int OUTPUT_SLOT = 16;
    private static final int[] BACKGROUND_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 13, 15, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};
    private static final int INPUT_TOOL = 10;
    private static final int INPUT_KIT = 12;

    public RepairBench(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    protected void craft(BlockMenu blockMenu, Player player) {
        ItemStack item = blockMenu.getItemInSlot(10);
        ItemStack kit = blockMenu.getItemInSlot(12);
        if (item == null) {
            player.sendMessage(ThemeUtils.WARNING + "Input a item into the first slot.");
            return;
        }
        if (!ItemUtils.isTool(item) && !ItemUtils.isArmour(item)) {
            player.sendMessage(ThemeUtils.WARNING + "The item in the first slot isn't a Tinker's item.");
            return;
        }
        if (kit == null || !RepairkitTemplate.isRepairKit(kit)) {
            player.sendMessage(ThemeUtils.WARNING + "Input a repair kit into the second slot.");
            return;
        }
        String toolMaterial = ItemUtils.getToolMaterial(item);
        String armourMaterial = ItemUtils.getArmourMaterial(item);
        String partMaterial = ItemUtils.getPartMaterial(kit);
        if (this.repairChecks(partMaterial, toolMaterial, armourMaterial, item)) {
            boolean freeFix;
            ItemStack newItem = item.clone();
            boolean fixAll = ItemUtils.repairBenchEasyFix(newItem);
            this.repairItemStack(newItem, fixAll);
            blockMenu.pushItem(newItem, new int[]{16});
            blockMenu.getItemInSlot(10).setAmount(blockMenu.getItemInSlot(10).getAmount() - 1);
            boolean bl = freeFix = ItemUtils.repairBenchCraftsman(newItem) && ThreadLocalRandom.current().nextInt(1, 5) == 1;
            if (!freeFix) {
                blockMenu.getItemInSlot(12).setAmount(blockMenu.getItemInSlot(12).getAmount() - 1);
            } else {
                player.sendMessage(ThemeUtils.SUCCESS + "Free repair!");
            }
        } else {
            player.sendMessage(ThemeUtils.WARNING + "The kit type does not match the item material.");
        }
    }

    private boolean repairChecks(String partMaterial, String toolMaterial, String armourMaterial, ItemStack itemStack) {
        return this.checkKit(partMaterial) && (this.checkTool(partMaterial, toolMaterial) || this.checkArmour(partMaterial, armourMaterial, itemStack));
    }

    private boolean checkKit(String partMaterial) {
        return partMaterial != null;
    }

    private boolean checkTool(String partMaterial, String toolMaterial) {
        return toolMaterial != null && toolMaterial.equals(partMaterial);
    }

    private boolean checkArmour(String partMaterial, String armourMaterial, ItemStack itemStack) {
        return armourMaterial != null && (armourMaterial.equals(partMaterial) || ItemUtils.repairBenchEasyFix2(itemStack));
    }

    protected void repairItemStack(ItemStack itemStack, boolean fixAll) {
        ItemMeta im = itemStack.getItemMeta();
        if (im instanceof Damageable) {
            Damageable damageable = (Damageable)im;
            int durability = fixAll ? 0 : Math.max(damageable.getDamage() - Math.floorDiv(itemStack.getType().getMaxDurability(), 3), 0);
            damageable.setDamage(durability);
        }
        itemStack.setItemMeta(im);
    }

    @Override
    protected void setup(BlockMenuPreset blockMenuPreset) {
        blockMenuPreset.drawBackground(ChestMenuUtils.getBackground(), BACKGROUND_SLOTS);
        blockMenuPreset.addItem(14, (ItemStack)GUIItems.MENU_CRAFT_REPAIR);
        blockMenuPreset.addMenuClickHandler(14, (player, i, itemStack, clickAction) -> false);
    }

    @Override
    protected int[] getInputSlots() {
        return new int[0];
    }

    @Override
    protected int[] getOutputSlots() {
        return new int[0];
    }

    @Override
    protected void onBreak(@Nonnull BlockBreakEvent event, @Nonnull BlockMenu blockMenu) {
        super.onBreak(event, blockMenu);
        Location location = blockMenu.getLocation();
        blockMenu.dropItems(location, new int[]{10});
        blockMenu.dropItems(location, new int[]{12});
        blockMenu.dropItems(location, new int[]{16});
    }

    @Override
    protected void onNewInstance(@Nonnull BlockMenu blockMenu, @Nonnull Block b) {
        super.onNewInstance(blockMenu, b);
        blockMenu.addMenuClickHandler(14, (player, i, itemStack, clickAction) -> {
            this.craft(blockMenu, player);
            return false;
        });
    }
}

