/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.items.tinkermaterials;

import com.google.common.base.Preconditions;
import io.github.sefiraat.slimetinker.SlimeTinker;
import io.github.sefiraat.slimetinker.events.friend.TraitPartType;
import io.github.sefiraat.slimetinker.items.Casts;
import io.github.sefiraat.slimetinker.items.Dies;
import io.github.sefiraat.slimetinker.items.Parts;
import io.github.sefiraat.slimetinker.items.tinkermaterials.TinkerMaterial;
import io.github.sefiraat.slimetinker.items.tinkermaterials.elements.Alloy;
import io.github.sefiraat.slimetinker.items.tinkermaterials.recipes.CastResult;
import io.github.sefiraat.slimetinker.items.tinkermaterials.recipes.MoltenResult;
import io.github.sefiraat.slimetinker.items.tinkermaterials.setup.TinkersMaterialsCore;
import io.github.sefiraat.slimetinker.items.tinkermaterials.setup.TinkersMaterialsDynatech;
import io.github.sefiraat.slimetinker.items.tinkermaterials.setup.TinkersMaterialsInfinity;
import io.github.sefiraat.slimetinker.items.tinkermaterials.setup.TinkersMaterialsLiteXpansion;
import io.github.sefiraat.slimetinker.items.tinkermaterials.setup.TinkersMaterialsNetworks;
import io.github.sefiraat.slimetinker.items.tinkermaterials.setup.TinkersMaterialsSlimefunWarfare;
import io.github.sefiraat.slimetinker.items.tinkermaterials.setup.TinkersMaterialsTranscEndence;
import io.github.sefiraat.slimetinker.managers.SupportedPluginsManager;
import io.github.sefiraat.slimetinker.managers.TraitManager;
import io.github.sefiraat.slimetinker.utils.ItemUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class TinkerMaterialManager {
    public static final int AMOUNT_NUGGET = 1;
    public static final int AMOUNT_INGOT = 9;
    public static final int AMOUNT_ORE = 18;
    public static final int AMOUNT_BLOCK = 81;
    public static final int AMOUNT_BOOT = 36;
    public static final int AMOUNT_LEG = 63;
    public static final int AMOUNT_CHEST = 72;
    public static final int AMOUNT_HELM = 45;
    public static final int AMOUNT_DUST = 9;
    public static final int AMOUNT_GEM = 9;
    public static final int AMOUNT_CAST = 18;
    public static final int AMOUNT_KIT = 27;
    public static final int AMOUNT_BUCKET = 729;
    public static final int AMOUNT_SHOVELHEAD = 9;
    public static final int AMOUNT_PICKAXEHEAD = 27;
    public static final int AMOUNT_AXEHEAD = 27;
    public static final int AMOUNT_HOEHEAD = 18;
    public static final int AMOUNT_SWORDBLADE = 18;
    public static final int AMOUNT_TOOLROD = 9;
    public static final int AMOUNT_ARM_HELM = 45;
    public static final int AMOUNT_ARM_CHEST = 72;
    public static final int AMOUNT_ARM_LEG = 63;
    public static final int AMOUNT_ARM_BOOT = 36;
    public static final int AMOUNT_ARM_LINKS = 18;
    protected static final Map<TinkerMaterial, ItemStack> MAP_DIE_NUGGET = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_DIE_INGOT = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_DIE_BLOCK = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_DIE_GEM = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_DIE_SHOVELHEAD = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_DIE_PICKAXEHEAD = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_DIE_AXEHEAD = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_DIE_HOEHEAD = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_DIE_SWORDBLADE = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_DIE_TOOLROD = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_DIE_ARMOUR_PLATES_HELM = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_DIE_ARMOUR_PLATES_CHEST = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_DIE_ARMOUR_PLATES_LEGGINGS = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_DIE_ARMOUR_PLATES_BOOTS = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_DIE_ARMOUR_MAIL = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_DIE_REPAIRKIT = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_CAST_NUGGET = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_CAST_INGOT = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_CAST_BLOCK = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_CAST_GEM = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_CAST_SHOVELHEAD = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_CAST_PICKAXEHEAD = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_CAST_AXEHEAD = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_CAST_HOEHEAD = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_CAST_SWORDBLADE = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_CAST_TOOLROD = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_CAST_ARMOUR_PLATES_HELM = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_CAST_ARMOUR_PLATES_CHEST = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_CAST_ARMOUR_PLATES_LEGGINGS = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_CAST_ARMOUR_PLATES_BOOTS = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_CAST_ARMOUR_MAIL = new HashMap<TinkerMaterial, ItemStack>();
    protected static final Map<TinkerMaterial, ItemStack> MAP_CAST_REPAIRKIT = new HashMap<TinkerMaterial, ItemStack>();
    private static final Map<String, TinkerMaterial> MAP = new HashMap<String, TinkerMaterial>();
    private static final String VALIDATE_TRAIT_MESSAGE = "The material {0} does not have a compatible trait type of {1}";
    public final Map<String, MoltenResult> meltingRecipes = new HashMap<String, MoltenResult>();
    public final Map<String, CastResult> castingRecipes = new HashMap<String, CastResult>();

    public TinkerMaterialManager() {
        MAP.putAll(TinkersMaterialsCore.getCmMap());
        if (SupportedPluginsManager.INFINITY_EXPANSION) {
            MAP.putAll(TinkersMaterialsInfinity.getCmMap());
        }
        if (SupportedPluginsManager.SLIMEFUN_WARFARE) {
            MAP.putAll(TinkersMaterialsSlimefunWarfare.getCmMap());
        }
        if (SupportedPluginsManager.DYNATECH) {
            MAP.putAll(TinkersMaterialsDynatech.getCmMap());
        }
        if (SupportedPluginsManager.LITEXPANSION) {
            MAP.putAll(TinkersMaterialsLiteXpansion.getCmMap());
        }
        if (SupportedPluginsManager.TRANSCENDENCE) {
            MAP.putAll(TinkersMaterialsTranscEndence.getCmMap());
        }
        if (SupportedPluginsManager.NETWORKS) {
            MAP.putAll(TinkersMaterialsNetworks.getCmMap());
        }
        TraitManager traitManager = SlimeTinker.getInstance().getTraitManager();
        for (Map.Entry<String, TinkerMaterial> entry : MAP.entrySet()) {
            ItemStack i;
            TinkerMaterial cm = entry.getValue();
            String id = entry.getKey();
            if (cm.getTraitToolRod() != null && traitManager.isEnabled(id, "ROD")) {
                MAP_CAST_TOOLROD.put(cm, Parts.TOOL_ROD.getStack(id, "ROD", null, cm.getColor()));
            }
            if (cm.getTraitArmorLinks() != null && traitManager.isEnabled(id, "LINKS")) {
                MAP_CAST_ARMOUR_MAIL.put(cm, Parts.MAIL_LINKS.getStack(id, "LINKS", null, cm.getColor()));
            }
            if (cm.getTraitToolHead() != null && traitManager.isEnabled(id, "HEAD")) {
                MAP_CAST_SWORDBLADE.put(cm, Parts.SWORD_BLADE.getStack(id, "HEAD", "SWORD", cm.getColor()));
                MAP_CAST_HOEHEAD.put(cm, Parts.HOE_HEAD.getStack(id, "HEAD", "HOE", cm.getColor()));
                MAP_CAST_AXEHEAD.put(cm, Parts.AXE_HEAD.getStack(id, "HEAD", "AXE", cm.getColor()));
                MAP_CAST_PICKAXEHEAD.put(cm, Parts.PICKAXE_HEAD.getStack(id, "HEAD", "PICK", cm.getColor()));
                MAP_CAST_SHOVELHEAD.put(cm, Parts.SHOVEL_HEAD.getStack(id, "HEAD", "SHOVEL", cm.getColor()));
            }
            if (cm.getTraitArmorPlates() != null && traitManager.isEnabled(id, "PLATE")) {
                MAP_CAST_ARMOUR_PLATES_HELM.put(cm, Parts.HELM_PLATE.getStack(id, "PLATE", "HELMET", cm.getColor()));
                MAP_CAST_ARMOUR_PLATES_CHEST.put(cm, Parts.CHEST_PLATE.getStack(id, "PLATE", "CHESTPLATE", cm.getColor()));
                MAP_CAST_ARMOUR_PLATES_LEGGINGS.put(cm, Parts.LEG_PLATE.getStack(id, "PLATE", "LEGGINGS", cm.getColor()));
                MAP_CAST_ARMOUR_PLATES_BOOTS.put(cm, Parts.BOOT_PLATE.getStack(id, "PLATE", "BOOTS", cm.getColor()));
            }
            if (cm.getTraitToolHead() != null || cm.getTraitArmorPlates() != null) {
                MAP_CAST_REPAIRKIT.put(cm, Parts.REPAIR_KIT.getStack(id, "REPAIR", cm.getColor()));
            }
            if (cm.getFormGem() != null) {
                i = ItemUtils.getItemByID(cm.getFormGem());
                if (i == null) {
                    i = new ItemStack(Material.valueOf((String)cm.getFormGem()));
                }
                MAP_CAST_GEM.put(cm, i);
                this.meltingRecipes.put(cm.getFormGem(), new MoltenResult(cm, 9));
            }
            if (cm.getFormBlock() != null) {
                i = ItemUtils.getItemByID(cm.getFormBlock());
                if (i == null) {
                    i = new ItemStack(Material.valueOf((String)cm.getFormBlock()));
                }
                MAP_CAST_BLOCK.put(cm, i);
                this.meltingRecipes.put(cm.getFormBlock(), new MoltenResult(cm, 81));
            }
            if (cm.getFormIngot() != null) {
                i = ItemUtils.getItemByID(cm.getFormIngot());
                if (i == null) {
                    i = new ItemStack(Material.valueOf((String)cm.getFormIngot()));
                }
                MAP_CAST_INGOT.put(cm, i);
                this.meltingRecipes.put(cm.getFormIngot(), new MoltenResult(cm, 9));
            }
            if (cm.getFormNugget() != null) {
                i = ItemUtils.getItemByID(cm.getFormNugget());
                if (i == null) {
                    i = new ItemStack(Material.valueOf((String)cm.getFormNugget()));
                }
                MAP_CAST_NUGGET.put(cm, i);
                this.meltingRecipes.put(cm.getFormNugget(), new MoltenResult(cm, 1));
            }
            if (cm.getFormOre() != null) {
                this.meltingRecipes.put(cm.getFormOre(), new MoltenResult(cm, 18));
            }
            if (cm.getFormDust() != null) {
                this.meltingRecipes.put(cm.getFormDust(), new MoltenResult(cm, 9));
            }
            if (cm.getFormHelmet() != null) {
                this.meltingRecipes.put(cm.getFormHelmet(), new MoltenResult(cm, 45));
            }
            if (cm.getFormChestplate() != null) {
                this.meltingRecipes.put(cm.getFormChestplate(), new MoltenResult(cm, 72));
            }
            if (cm.getFormLeggings() != null) {
                this.meltingRecipes.put(cm.getFormLeggings(), new MoltenResult(cm, 63));
            }
            if (cm.getFormBoots() == null) continue;
            this.meltingRecipes.put(cm.getFormBoots(), new MoltenResult(cm, 36));
        }
        this.fillDieMetals();
        this.fillCastingDies();
        this.fillCastingRecipes();
    }

    public static TinkerMaterial getById(String id) {
        return MAP.get(id);
    }

    public static ChatColor getColorById(String id) {
        return MAP.get(id).getColor();
    }

    public static String getTraitName(String id, TraitPartType partType) {
        TinkerMaterial tinkerMaterial = MAP.get(id);
        if (partType == TraitPartType.HEAD) {
            Preconditions.checkNotNull((Object)tinkerMaterial.getTraitToolHead(), (Object)MessageFormat.format(VALIDATE_TRAIT_MESSAGE, new Object[]{id, partType}));
            return tinkerMaterial.getTraitToolHead().getTraitName();
        }
        if (partType == TraitPartType.BINDER) {
            Preconditions.checkNotNull((Object)tinkerMaterial.getTraitToolBinder(), (Object)MessageFormat.format(VALIDATE_TRAIT_MESSAGE, new Object[]{id, partType}));
            return tinkerMaterial.getTraitToolBinder().getTraitName();
        }
        if (partType == TraitPartType.ROD) {
            Preconditions.checkNotNull((Object)tinkerMaterial.getTraitToolRod(), (Object)MessageFormat.format(VALIDATE_TRAIT_MESSAGE, new Object[]{id, partType}));
            return tinkerMaterial.getTraitToolRod().getTraitName();
        }
        if (partType == TraitPartType.PLATES) {
            Preconditions.checkNotNull((Object)tinkerMaterial.getTraitArmorPlates(), (Object)MessageFormat.format(VALIDATE_TRAIT_MESSAGE, new Object[]{id, partType}));
            return tinkerMaterial.getTraitArmorPlates().getTraitName();
        }
        if (partType == TraitPartType.GAMBESON) {
            Preconditions.checkNotNull((Object)tinkerMaterial.getTraitArmorGambeson(), (Object)MessageFormat.format(VALIDATE_TRAIT_MESSAGE, new Object[]{id, partType}));
            return tinkerMaterial.getTraitArmorGambeson().getTraitName();
        }
        if (partType == TraitPartType.LINKS) {
            Preconditions.checkNotNull((Object)tinkerMaterial.getTraitArmorLinks(), (Object)MessageFormat.format(VALIDATE_TRAIT_MESSAGE, new Object[]{id, partType}));
            return tinkerMaterial.getTraitArmorLinks().getTraitName();
        }
        return "Error";
    }

    public static List<Alloy> getAlloys() {
        ArrayList<Alloy> list = new ArrayList<Alloy>();
        for (TinkerMaterial cm : MAP.values()) {
            if (cm.getCmAlloy() == null) continue;
            list.add(cm.getCmAlloy());
        }
        return list;
    }

    private void fillDieMetals() {
        MAP_DIE_NUGGET.put(TinkerMaterialManager.getById("GOLD"), (ItemStack)Casts.CAST_NUGGET);
        MAP_DIE_INGOT.put(TinkerMaterialManager.getById("GOLD"), (ItemStack)Casts.CAST_INGOT);
        MAP_DIE_BLOCK.put(TinkerMaterialManager.getById("GOLD"), (ItemStack)Casts.CAST_BLOCK);
        MAP_DIE_GEM.put(TinkerMaterialManager.getById("GOLD"), (ItemStack)Casts.CAST_GEM);
        MAP_DIE_REPAIRKIT.put(TinkerMaterialManager.getById("GOLD"), (ItemStack)Casts.CAST_REPAIRKIT);
        MAP_DIE_SHOVELHEAD.put(TinkerMaterialManager.getById("BRASS"), (ItemStack)Casts.CAST_SHOVELHEAD);
        MAP_DIE_PICKAXEHEAD.put(TinkerMaterialManager.getById("BRASS"), (ItemStack)Casts.CAST_PICKAXEHEAD);
        MAP_DIE_AXEHEAD.put(TinkerMaterialManager.getById("BRASS"), (ItemStack)Casts.CAST_AXEHEAD);
        MAP_DIE_HOEHEAD.put(TinkerMaterialManager.getById("BRASS"), (ItemStack)Casts.CAST_HOEHEAD);
        MAP_DIE_SWORDBLADE.put(TinkerMaterialManager.getById("BRASS"), (ItemStack)Casts.CAST_SWORDBLADE);
        MAP_DIE_TOOLROD.put(TinkerMaterialManager.getById("BRASS"), (ItemStack)Casts.CAST_TOOLROD);
        MAP_DIE_ARMOUR_PLATES_HELM.put(TinkerMaterialManager.getById("BRASS"), (ItemStack)Casts.CAST_HELM_PLATE);
        MAP_DIE_ARMOUR_PLATES_CHEST.put(TinkerMaterialManager.getById("BRASS"), (ItemStack)Casts.CAST_CHEST_PLATE);
        MAP_DIE_ARMOUR_PLATES_LEGGINGS.put(TinkerMaterialManager.getById("BRASS"), (ItemStack)Casts.CAST_LEG_PLATE);
        MAP_DIE_ARMOUR_PLATES_BOOTS.put(TinkerMaterialManager.getById("BRASS"), (ItemStack)Casts.CAST_BOOT_PLATE);
        MAP_DIE_ARMOUR_MAIL.put(TinkerMaterialManager.getById("BRASS"), (ItemStack)Casts.CAST_MAIL_LINK);
    }

    private void fillCastingDies() {
        this.castingRecipes.put(Material.IRON_NUGGET.toString(), new CastResult(Material.IRON_NUGGET.toString(), 18, MAP_DIE_NUGGET, true));
        this.castingRecipes.put(Material.BRICK.toString(), new CastResult(Material.BRICK.toString(), 18, MAP_DIE_INGOT, true));
        this.castingRecipes.put(Material.STONE.toString(), new CastResult(Material.STONE.toString(), 18, MAP_DIE_BLOCK, true));
        this.castingRecipes.put(Material.DIAMOND.toString(), new CastResult(Material.DIAMOND.toString(), 18, MAP_DIE_GEM, true));
        this.castingRecipes.put(Dies.DIE_REPAIR_KIT.getItemId(), new CastResult(Dies.DIE_REPAIR_KIT.getItemId(), 18, MAP_DIE_REPAIRKIT, true));
        this.castingRecipes.put(Dies.DIE_SHOVEL_HEAD.getItemId(), new CastResult(Dies.DIE_SHOVEL_HEAD.getItemId(), 18, MAP_DIE_SHOVELHEAD, true));
        this.castingRecipes.put(Dies.DIE_PICKAXE_HEAD.getItemId(), new CastResult(Dies.DIE_PICKAXE_HEAD.getItemId(), 18, MAP_DIE_PICKAXEHEAD, true));
        this.castingRecipes.put(Dies.DIE_AXE_HEAD.getItemId(), new CastResult(Dies.DIE_AXE_HEAD.getItemId(), 18, MAP_DIE_AXEHEAD, true));
        this.castingRecipes.put(Dies.DIE_HOE_HEAD.getItemId(), new CastResult(Dies.DIE_HOE_HEAD.getItemId(), 18, MAP_DIE_HOEHEAD, true));
        this.castingRecipes.put(Dies.DIE_SWORD_BLADE.getItemId(), new CastResult(Dies.DIE_SWORD_BLADE.getItemId(), 18, MAP_DIE_SWORDBLADE, true));
        this.castingRecipes.put(Dies.DIE_TOOL_ROD.getItemId(), new CastResult(Dies.DIE_TOOL_ROD.getItemId(), 18, MAP_DIE_TOOLROD, true));
        this.castingRecipes.put(Dies.DIE_HELM_PLATE.getItemId(), new CastResult(Dies.DIE_HELM_PLATE.getItemId(), 18, MAP_DIE_ARMOUR_PLATES_HELM, true));
        this.castingRecipes.put(Dies.DIE_CHEST_PLATE.getItemId(), new CastResult(Dies.DIE_CHEST_PLATE.getItemId(), 18, MAP_DIE_ARMOUR_PLATES_CHEST, true));
        this.castingRecipes.put(Dies.DIE_LEG_PLATE.getItemId(), new CastResult(Dies.DIE_LEG_PLATE.getItemId(), 18, MAP_DIE_ARMOUR_PLATES_LEGGINGS, true));
        this.castingRecipes.put(Dies.DIE_BOOT_PLATE.getItemId(), new CastResult(Dies.DIE_BOOT_PLATE.getItemId(), 18, MAP_DIE_ARMOUR_PLATES_BOOTS, true));
        this.castingRecipes.put(Dies.DIE_MAIL_LINK.getItemId(), new CastResult(Dies.DIE_MAIL_LINK.getItemId(), 18, MAP_DIE_ARMOUR_MAIL, true));
    }

    private void fillCastingRecipes() {
        this.castingRecipes.put(Casts.CAST_NUGGET.getItemId(), new CastResult(Casts.CAST_NUGGET.getItemId(), 1, MAP_CAST_NUGGET, false));
        this.castingRecipes.put(Casts.CAST_INGOT.getItemId(), new CastResult(Casts.CAST_INGOT.getItemId(), 9, MAP_CAST_INGOT, false));
        this.castingRecipes.put(Casts.CAST_BLOCK.getItemId(), new CastResult(Casts.CAST_BLOCK.getItemId(), 81, MAP_CAST_BLOCK, false));
        this.castingRecipes.put(Casts.CAST_GEM.getItemId(), new CastResult(Casts.CAST_GEM.getItemId(), 9, MAP_CAST_GEM, false));
        this.castingRecipes.put(Casts.CAST_REPAIRKIT.getItemId(), new CastResult(Casts.CAST_REPAIRKIT.getItemId(), 27, MAP_CAST_REPAIRKIT, false));
        this.castingRecipes.put(Casts.CAST_SHOVELHEAD.getItemId(), new CastResult(Casts.CAST_SHOVELHEAD.getItemId(), 9, MAP_CAST_SHOVELHEAD, false));
        this.castingRecipes.put(Casts.CAST_PICKAXEHEAD.getItemId(), new CastResult(Casts.CAST_PICKAXEHEAD.getItemId(), 27, MAP_CAST_PICKAXEHEAD, false));
        this.castingRecipes.put(Casts.CAST_AXEHEAD.getItemId(), new CastResult(Casts.CAST_AXEHEAD.getItemId(), 27, MAP_CAST_AXEHEAD, false));
        this.castingRecipes.put(Casts.CAST_HOEHEAD.getItemId(), new CastResult(Casts.CAST_HOEHEAD.getItemId(), 18, MAP_CAST_HOEHEAD, false));
        this.castingRecipes.put(Casts.CAST_SWORDBLADE.getItemId(), new CastResult(Casts.CAST_SWORDBLADE.getItemId(), 18, MAP_CAST_SWORDBLADE, false));
        this.castingRecipes.put(Casts.CAST_TOOLROD.getItemId(), new CastResult(Casts.CAST_TOOLROD.getItemId(), 9, MAP_CAST_TOOLROD, false));
        this.castingRecipes.put(Casts.CAST_HELM_PLATE.getItemId(), new CastResult(Casts.CAST_HELM_PLATE.getItemId(), 45, MAP_CAST_ARMOUR_PLATES_HELM, false));
        this.castingRecipes.put(Casts.CAST_CHEST_PLATE.getItemId(), new CastResult(Casts.CAST_CHEST_PLATE.getItemId(), 72, MAP_CAST_ARMOUR_PLATES_CHEST, false));
        this.castingRecipes.put(Casts.CAST_LEG_PLATE.getItemId(), new CastResult(Casts.CAST_LEG_PLATE.getItemId(), 63, MAP_CAST_ARMOUR_PLATES_LEGGINGS, false));
        this.castingRecipes.put(Casts.CAST_BOOT_PLATE.getItemId(), new CastResult(Casts.CAST_BOOT_PLATE.getItemId(), 36, MAP_CAST_ARMOUR_PLATES_BOOTS, false));
        this.castingRecipes.put(Casts.CAST_MAIL_LINK.getItemId(), new CastResult(Casts.CAST_MAIL_LINK.getItemId(), 18, MAP_CAST_ARMOUR_MAIL, false));
    }

    public static Map<String, TinkerMaterial> getMap() {
        return MAP;
    }
}

