/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.listeners;

import com.google.common.base.Preconditions;
import io.github.sefiraat.slimetinker.events.friend.EventChannels;
import io.github.sefiraat.slimetinker.events.friend.EventFriend;
import io.github.sefiraat.slimetinker.events.friend.TraitEventType;
import io.github.sefiraat.slimetinker.utils.Experience;
import io.github.sefiraat.slimetinker.utils.ItemUtils;
import io.github.sefiraat.slimetinker.utils.ThemeUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class PlayerInteractListener
implements Listener {
    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        EventFriend friend = new EventFriend(player, TraitEventType.INTERACT);
        friend.setBlock(event.getClickedBlock());
        friend.setAction(event.getAction());
        EventChannels.checkTool(friend);
        EventChannels.checkArmour(friend);
        if (friend.isActionTaken()) {
            EventChannels.settlePotionEffects(friend);
        }
    }

    @EventHandler
    public void onTillOrPath(PlayerInteractEvent event) {
        ItemStack itemStack;
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && this.eventIsTinkersTillOrPath(itemStack = event.getItem(), event.getClickedBlock())) {
            if (ItemUtils.isTinkersBroken(itemStack)) {
                event.setCancelled(true);
                event.getPlayer().sendMessage(ThemeUtils.WARNING + "Your tool is broken, you should really repair it!");
            } else {
                Experience.addExp(itemStack, 1, event.getPlayer(), true);
            }
        }
    }

    public boolean eventIsTinkersTillOrPath(ItemStack itemStack, Block block) {
        if (ItemUtils.isTool(itemStack)) {
            String type = ItemUtils.getToolTypeName(itemStack);
            Preconditions.checkNotNull((Object)type, (Object)"Item is tool but without a type? /sf cheat or other error has happened.");
            return !(!type.equals("HOE") && !type.equals("SHOVEL") || block.getType() != Material.DIRT && block.getType() != Material.GRASS_BLOCK);
        }
        return false;
    }
}

