/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.items.workstations.swappingstation;

import com.google.common.base.Preconditions;
import io.github.sefiraat.slimetinker.infinitylib.machines.MenuBlock;
import io.github.sefiraat.slimetinker.utils.GUIItems;
import io.github.sefiraat.slimetinker.utils.ItemUtils;
import io.github.sefiraat.slimetinker.utils.Keys;
import io.github.sefiraat.slimetinker.utils.ThemeUtils;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;

public class SwappingStation
extends MenuBlock {
    protected static final int CRAFT_BUTTON = 14;
    protected static final int OUTPUT_SLOT = 16;
    private static final int[] BACKGROUND_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 13, 15, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};
    private static final int INPUT_ITEM = 10;
    private static final int INPUT_PART = 12;

    public SwappingStation(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    protected void craft(BlockMenu blockMenu, Player player) {
        ItemStack item = blockMenu.getItemInSlot(10);
        ItemStack part = blockMenu.getItemInSlot(12);
        if (item == null) {
            player.sendMessage(ThemeUtils.WARNING + "Input a tool into the first slot.");
            return;
        }
        if (item.getAmount() > 1) {
            player.sendMessage(ThemeUtils.WARNING + "Nope - nerd");
            return;
        }
        if (part == null) {
            player.sendMessage(ThemeUtils.WARNING + "Input a replacement part into the second slot.");
            return;
        }
        String partClass = ItemUtils.getPartClass(part);
        String partType = ItemUtils.getPartType(part);
        String partMaterial = ItemUtils.getPartMaterial(part);
        if (ItemUtils.isTool(item)) {
            if (partClass != null && ItemUtils.partIsTool(partClass)) {
                this.swapTool(blockMenu, player, item, partClass, partType, partMaterial);
            } else {
                player.sendMessage(ThemeUtils.WARNING + "This part cannot be swapped onto this tool.");
            }
        } else if (ItemUtils.isArmour(item)) {
            if (partClass != null && ItemUtils.partIsArmour(partClass)) {
                this.swapArmour(blockMenu, player, item, partClass, partType, partMaterial);
            } else {
                player.sendMessage(ThemeUtils.WARNING + "This part cannot be swapped onto this tool.");
            }
        } else {
            player.sendMessage(ThemeUtils.WARNING + "The item in the first slot isn't a Tinker's item.");
        }
    }

    private void swapTool(BlockMenu blockMenu, Player player, ItemStack item, String partClass, String partType, String partMaterial) {
        if (partClass.equals("HEAD") && partType != null && !partType.equals(ItemUtils.getToolTypeName(item))) {
            player.sendMessage(ThemeUtils.WARNING + "This head type cannot be swapped onto this tool.");
            return;
        }
        ItemStack newTool = item.clone();
        ItemMeta newToolMeta = newTool.getItemMeta();
        this.checkAndChangeExplosiveness(newTool, newToolMeta, partMaterial, partClass);
        switch (partClass) {
            case "HEAD": {
                PersistentDataAPI.setString((PersistentDataHolder)newToolMeta, (NamespacedKey)Keys.TOOL_INFO_HEAD_MATERIAL, (String)partMaterial);
                break;
            }
            case "BINDING": {
                PersistentDataAPI.setString((PersistentDataHolder)newToolMeta, (NamespacedKey)Keys.TOOL_INFO_BINDER_MATERIAL, (String)partMaterial);
                break;
            }
            case "ROD": {
                PersistentDataAPI.setString((PersistentDataHolder)newToolMeta, (NamespacedKey)Keys.TOOL_INFO_ROD_MATERIAL, (String)partMaterial);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + partClass);
            }
        }
        newTool.setItemMeta(newToolMeta);
        ItemUtils.rebuildTinkerLore(newTool);
        ItemUtils.rebuildTinkerName(newTool);
        blockMenu.pushItem(newTool, new int[]{16});
        blockMenu.getItemInSlot(10).setAmount(blockMenu.getItemInSlot(10).getAmount() - 1);
        blockMenu.getItemInSlot(12).setAmount(blockMenu.getItemInSlot(12).getAmount() - 1);
    }

    private void swapArmour(BlockMenu blockMenu, Player player, ItemStack item, String partClass, String partType, String partMaterial) {
        if (partClass.equals("PLATE") && partType != null && !partType.equals(ItemUtils.getArmourTypeName(item))) {
            player.sendMessage(ThemeUtils.WARNING + "This plate type cannot be swapped onto this armour.");
            return;
        }
        ItemStack newArmour = item.clone();
        ItemMeta newArmourMeta = newArmour.getItemMeta();
        switch (partClass) {
            case "PLATE": {
                PersistentDataAPI.setString((PersistentDataHolder)newArmourMeta, (NamespacedKey)Keys.ARMOUR_INFO_PLATE_MATERIAL, (String)partMaterial);
                break;
            }
            case "GAMBESON": {
                PersistentDataAPI.setString((PersistentDataHolder)newArmourMeta, (NamespacedKey)Keys.ARMOUR_INFO_GAMBESON_MATERIAL, (String)partMaterial);
                break;
            }
            case "LINKS": {
                PersistentDataAPI.setString((PersistentDataHolder)newArmourMeta, (NamespacedKey)Keys.ARMOUR_INFO_LINKS_MATERIAL, (String)partMaterial);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + partClass);
            }
        }
        newArmour.setItemMeta(newArmourMeta);
        ItemUtils.rebuildTinkerLore(newArmour);
        ItemUtils.rebuildTinkerName(newArmour);
        blockMenu.pushItem(newArmour, new int[]{16});
        blockMenu.getItemInSlot(10).setAmount(blockMenu.getItemInSlot(10).getAmount() - 1);
        blockMenu.getItemInSlot(12).setAmount(blockMenu.getItemInSlot(12).getAmount() - 1);
    }

    private void checkAndChangeExplosiveness(ItemStack newTool, ItemMeta im, String partMaterial, String partClass) {
        Preconditions.checkNotNull((Object)Slimefun.instance(), (Object)"Slimefun is null, that's... not great?");
        NamespacedKey sfIDKey = new NamespacedKey((Plugin)Slimefun.instance(), "slimefun_item");
        Object sID = PersistentDataAPI.getString((PersistentDataHolder)im, (NamespacedKey)sfIDKey);
        if (this.isExplosivePart(partMaterial, partClass) && !ItemUtils.isToolExplosive(newTool)) {
            sID = (String)sID + "_EXP";
            PersistentDataAPI.setString((PersistentDataHolder)im, (NamespacedKey)sfIDKey, (String)sID);
        } else if (!this.isExplosivePart(partMaterial, partClass) && ItemUtils.isToolExplosive(newTool)) {
            sID = ((String)sID).replace("_EXP", "");
            PersistentDataAPI.setString((PersistentDataHolder)im, (NamespacedKey)sfIDKey, (String)sID);
        }
    }

    @Override
    protected void setup(BlockMenuPreset blockMenuPreset) {
        blockMenuPreset.drawBackground(ChestMenuUtils.getBackground(), BACKGROUND_SLOTS);
        blockMenuPreset.addItem(14, (ItemStack)GUIItems.MENU_CRAFT_SWAP);
        blockMenuPreset.addMenuClickHandler(14, (player, i, itemStack, clickAction) -> false);
    }

    @Override
    protected int[] getInputSlots() {
        return new int[0];
    }

    @Override
    protected int[] getOutputSlots() {
        return new int[0];
    }

    @Override
    protected void onBreak(@Nonnull BlockBreakEvent event, @Nonnull BlockMenu blockMenu) {
        super.onBreak(event, blockMenu);
        Location location = blockMenu.getLocation();
        blockMenu.dropItems(location, new int[]{10});
        blockMenu.dropItems(location, new int[]{12});
        blockMenu.dropItems(location, new int[]{16});
    }

    @Override
    protected void onNewInstance(@Nonnull BlockMenu blockMenu, @Nonnull Block b) {
        super.onNewInstance(blockMenu, b);
        blockMenu.addMenuClickHandler(14, (player, i, itemStack, clickAction) -> {
            this.craft(blockMenu, player);
            return false;
        });
    }

    private boolean isExplosivePart(String material, String part) {
        return material.equals("REINFORCED_ALLOY") && part.equals("HEAD") || material.equals("HARDENED_METAL") && part.equals("ROD") || material.equals("INFINITY_SINGULARITY") && part.equals("HEAD") || material.equals("OSMIUM") && part.equals("HEAD");
    }
}

