/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.commands;

import io.github.sefiraat.slimetinker.acf.BaseCommand;
import io.github.sefiraat.slimetinker.acf.annotation.CommandAlias;
import io.github.sefiraat.slimetinker.acf.annotation.CommandCompletion;
import io.github.sefiraat.slimetinker.acf.annotation.CommandPermission;
import io.github.sefiraat.slimetinker.acf.annotation.Default;
import io.github.sefiraat.slimetinker.acf.annotation.Description;
import io.github.sefiraat.slimetinker.acf.annotation.Subcommand;
import io.github.sefiraat.slimetinker.items.Guide;
import io.github.sefiraat.slimetinker.items.templates.ArmourDefinition;
import io.github.sefiraat.slimetinker.items.templates.ToolDefinition;
import io.github.sefiraat.slimetinker.utils.Experience;
import io.github.sefiraat.slimetinker.utils.ItemUtils;
import io.github.sefiraat.slimetinker.utils.ThemeUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@CommandAlias(value="SlimeTinker|st|tinker")
public class Commands
extends BaseCommand {
    @Default
    public void onDefault(CommandSender sender) {
        if (sender instanceof Player) {
            sender.sendMessage(ThemeUtils.ERROR + "Please provide a valid subcommand.");
        }
    }

    @Subcommand(value="AddExp")
    @CommandPermission(value="SlimeTinker.Admin")
    @CommandCompletion(value="<amount>")
    @Description(value="Adds EXP to the held item")
    public void tool(CommandSender sender, int amount) {
        if (sender instanceof Player) {
            Player p = (Player)sender;
            ItemStack i = p.getInventory().getItemInMainHand();
            if (ItemUtils.isTool(i) || ItemUtils.isArmour(i)) {
                Experience.addExp(i, amount, p, false);
            }
        } else {
            sender.sendMessage(ThemeUtils.ERROR + "This can only be done as a player.");
        }
    }

    @Subcommand(value="GenerateItem")
    @CommandPermission(value="SlimeTinker.Admin")
    @Description(value="Creates a new SlimeTinker item")
    public class GenerateItem
    extends BaseCommand {
        @Subcommand(value="Armour")
        @CommandCompletion(value="@ITEM_CLASS_ARMOUR @PART_MATERIALS_PLATE @PART_MATERIALS_GAMBESON @PART_MATERIALS_LINKS")
        @Description(value="Creates a new SlimeTinker armour piece with the given materials")
        public void armour(CommandSender sender, String type, String plateMat, String gambesonMat, String linksMat) {
            if (sender instanceof Player) {
                Player p = (Player)sender;
                ArmourDefinition armour = new ArmourDefinition("PLATE", type, plateMat, gambesonMat, linksMat);
                p.getInventory().addItem(new ItemStack[]{Guide.HELM.getStack(armour)});
            } else {
                sender.sendMessage(ThemeUtils.ERROR + "This can only be done as a player.");
            }
        }

        @Subcommand(value="Tool")
        @CommandCompletion(value="@ITEM_CLASS_TOOL @PART_MATERIALS_HEAD @PART_MATERIALS_BINDER @PART_MATERIALS_ROD")
        @Description(value="Creates a new SlimeTinker tool with the given materials")
        public void tool(CommandSender sender, String type, String headMat, String binderMat, String rodMat) {
            if (sender instanceof Player) {
                Player p = (Player)sender;
                ToolDefinition tool = new ToolDefinition("HEAD", type, headMat, binderMat, rodMat);
                if (ItemUtils.isToolExplosive(headMat, rodMat)) {
                    p.getInventory().addItem(new ItemStack[]{Guide.EXP_SHOVEL.getStack(tool)});
                } else {
                    p.getInventory().addItem(new ItemStack[]{Guide.SHOVEL.getStack(tool)});
                }
            } else {
                sender.sendMessage(ThemeUtils.ERROR + "This can only be done as a player.");
            }
        }
    }
}

